/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatImportDialog
extends JPanel {
    private JOptionPane optionPane;
    private JCheckBox delete;
    private JComboBox portCombo;
    private List<CommPortIdentifier> ports = new LinkedList<CommPortIdentifier>();

    public GlobalsatImportDialog() {
        this.portCombo = new JComboBox();
        this.portCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return new JLabel(((CommPortIdentifier)object).getName());
            }
        });
        this.portCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.pref.put("globalsat.portIdentifier", ((CommPortIdentifier)GlobalsatImportDialog.this.portCombo.getSelectedItem()).getName());
            }
        });
        this.refreshPorts();
        this.delete = new JCheckBox(I18n.tr((String)"delete data after import"));
        this.delete.setSelected(Main.pref.getBoolean("globalsat.deleteAfterDownload", false));
        this.setLayout(new GridBagLayout());
        this.add(this.portCombo);
        this.add(this.delete);
    }

    public void refreshPorts() {
        this.portCombo.removeAllItems();
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            this.portCombo.addItem(commPortIdentifier);
        }
        this.portCombo.setSelectedItem(Main.pref.get("globalsat.portIdentifier"));
    }

    public boolean deleteFilesAfterDownload() {
        return this.delete.isSelected();
    }

    public CommPortIdentifier getPort() {
        return (CommPortIdentifier)this.portCombo.getSelectedItem();
    }

    public void setOptionPane(JOptionPane jOptionPane) {
        this.optionPane = jOptionPane;
    }
}

