/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Properties;

public class Dg100Config {
    private byte logFormat = (byte)-1;
    private byte disableLogSpeed = (byte)-1;
    private int speedThres = -1;
    private byte disableLogDist = (byte)-1;
    private int distThres = -1;
    private int swATime = -1;
    private int swBTime = -1;
    private int swCTime = -1;
    private short unk1 = (short)-1;
    private byte swATimeOrDist = (byte)-1;
    private byte swBTimeOrDist = (byte)-1;
    private byte swCTimeOrDist = (byte)-1;
    private int swADist = -1;
    private int swBDist = -1;
    private int swCDist = -1;
    private byte unk2 = (byte)-1;
    private int remainder = -1;
    private int unk3 = -1;
    private int unk4 = -1;
    private static String propLogFormat = "logFormat";
    private static String propDisableLogSpeed = "disableLogSpeed";
    private static String propSpeedThres = "speedThres";
    private static String propDisableLogDist = "disableLogDist";
    private static String propDistThres = "distThres";
    private static String propSwATime = "swATime";
    private static String propSwBTime = "swBTime";
    private static String propSwCTime = "swCTime";
    private static String propUnk1 = "unk1";
    private static String propSwATimeOrDist = "swATimeOrDist";
    private static String propSwBTimeOrDist = "swBTimeOrDist";
    private static String propSwCTimeOrDist = "swCTimeOrDist";
    private static String propSwADist = "swADist";
    private static String propSwBDist = "swBDist";
    private static String propSwCDist = "swCDist";
    private static String propUnk2 = "unk2";
    private static String propRemainder = "remainder";
    private static String propUnk3 = "unk3";
    private static String propUnk4 = "unk4";

    public Dg100Config(ByteBuffer byteBuffer) {
        this.logFormat = byteBuffer.get();
        this.disableLogSpeed = byteBuffer.get();
        this.speedThres = byteBuffer.getInt();
        this.disableLogDist = byteBuffer.get();
        this.distThres = byteBuffer.getInt();
        this.swATime = byteBuffer.getInt();
        this.swBTime = byteBuffer.getInt();
        this.swCTime = byteBuffer.getInt();
        this.unk1 = byteBuffer.getShort();
        this.swATimeOrDist = byteBuffer.get();
        this.swBTimeOrDist = byteBuffer.get();
        this.swCTimeOrDist = byteBuffer.get();
        this.swADist = byteBuffer.getInt();
        this.swBDist = byteBuffer.getInt();
        this.swCDist = byteBuffer.getInt();
        this.unk2 = byteBuffer.get();
        this.remainder = byteBuffer.get();
        this.unk3 = byteBuffer.get();
        this.unk4 = byteBuffer.get();
    }

    public Dg100Config(String string) throws Exception {
        this.readProps(string);
    }

    public String toString() {
        return "[Dg100Config: logFormat = " + this.logFormat + ",disableLogSpeed = " + this.disableLogSpeed + ",speedThres = " + this.speedThres + ",disableLogDist = " + this.disableLogDist + ",distThres = " + this.distThres + ",swATime = " + this.swATime + ",swBTime = " + this.swBTime + ",swCTime = " + this.swCTime + ",unk1 = " + this.unk1 + ",swATimeOrDist = " + this.swATimeOrDist + ",swBTimeOrDist = " + this.swBTimeOrDist + ",swCTimeOrDist = " + this.swCTimeOrDist + ",swADist = " + this.swADist + ",swBDist = " + this.swBDist + ",swCDist = " + this.swCDist + ",unk2 = " + this.unk2 + ",remainder = " + this.remainder + ",unk3 = " + this.unk3 + ",unk4 = " + this.unk4;
    }

    public void write(ByteBuffer byteBuffer) {
        byteBuffer.position(5);
        byteBuffer.put(this.logFormat);
        byteBuffer.put(this.disableLogSpeed);
        byteBuffer.putInt(this.speedThres);
        byteBuffer.put(this.disableLogDist);
        byteBuffer.putInt(this.distThres);
        byteBuffer.putInt(this.swATime);
        byteBuffer.putInt(this.swBTime);
        byteBuffer.putInt(this.swCTime);
        byteBuffer.putShort(this.unk1);
        byteBuffer.put(this.swATimeOrDist);
        byteBuffer.put(this.swBTimeOrDist);
        byteBuffer.put(this.swCTimeOrDist);
        byteBuffer.putInt(this.swADist);
        byteBuffer.putInt(this.swBDist);
        byteBuffer.putInt(this.swCDist);
        byteBuffer.put(this.unk2);
    }

    public byte getDisableLogDist() {
        return this.disableLogDist;
    }

    public void setDisableLogDist(byte by) {
        this.disableLogDist = by;
    }

    public byte getDisableLogSpeed() {
        return this.disableLogSpeed;
    }

    public void setDisableLogSpeed(byte by) {
        this.disableLogSpeed = by;
    }

    public int getDistThres() {
        return this.distThres;
    }

    public void setDistThres(int n) {
        this.distThres = n;
    }

    public byte getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(byte by) {
        this.logFormat = by;
    }

    public int getSpeedThres() {
        return this.speedThres;
    }

    public void setSpeedThres(int n) {
        this.speedThres = n;
    }

    public int getSwADist() {
        return this.swADist;
    }

    public void setSwADist(int n) {
        this.swADist = n;
    }

    public int getSwATime() {
        return this.swATime;
    }

    public void setSwATime(int n) {
        this.swATime = n;
    }

    public byte getSwATimeOrDist() {
        return this.swATimeOrDist;
    }

    public void setSwATimeOrDist(byte by) {
        this.swATimeOrDist = by;
    }

    public int getSwBDist() {
        return this.swBDist;
    }

    public void setSwBDist(int n) {
        this.swBDist = n;
    }

    public int getSwBTime() {
        return this.swBTime;
    }

    public void setSwBTime(int n) {
        this.swBTime = n;
    }

    public byte getSwBTimeOrDist() {
        return this.swBTimeOrDist;
    }

    public void setSwBTimeOrDist(byte by) {
        this.swBTimeOrDist = by;
    }

    public int getSwCDist() {
        return this.swCDist;
    }

    public void setSwCDist(int n) {
        this.swCDist = n;
    }

    public int getSwCTime() {
        return this.swCTime;
    }

    public void setSwCTime(int n) {
        this.swCTime = n;
    }

    public byte getSwCTimeOrDist() {
        return this.swCTimeOrDist;
    }

    public void setSwCTimeOrDist(byte by) {
        this.swCTimeOrDist = by;
    }

    public short getUnk1() {
        return this.unk1;
    }

    public void setUnk1(short s) {
        this.unk1 = s;
    }

    public byte getUnk2() {
        return this.unk2;
    }

    public void setUnk2(byte by) {
        this.unk2 = by;
    }

    public int getRemainder() {
        return this.remainder;
    }

    public int getUnk3() {
        return this.unk3;
    }

    public int getUnk4() {
        return this.unk4;
    }

    public void writeProps(String string) throws Exception {
        Properties properties = new Properties();
        properties.setProperty(propLogFormat, "" + this.logFormat);
        properties.setProperty(propDisableLogSpeed, "" + this.disableLogSpeed);
        properties.setProperty(propSpeedThres, "" + this.speedThres);
        properties.setProperty(propDisableLogDist, "" + this.disableLogDist);
        properties.setProperty(propDistThres, "" + this.distThres);
        properties.setProperty(propSwATime, "" + this.swATime);
        properties.setProperty(propSwBTime, "" + this.swBTime);
        properties.setProperty(propSwCTime, "" + this.swCTime);
        properties.setProperty(propUnk1, "" + this.unk1);
        properties.setProperty(propSwATimeOrDist, "" + this.swATimeOrDist);
        properties.setProperty(propSwBTimeOrDist, "" + this.swBTimeOrDist);
        properties.setProperty(propSwCTimeOrDist, "" + this.swCTimeOrDist);
        properties.setProperty(propSwADist, "" + this.swADist);
        properties.setProperty(propSwBDist, "" + this.swBDist);
        properties.setProperty(propSwCDist, "" + this.swCDist);
        properties.setProperty(propUnk2, "" + this.unk2);
        properties.setProperty(propRemainder, "" + this.remainder);
        properties.setProperty(propUnk3, "" + this.unk3);
        properties.setProperty(propUnk4, "" + this.unk4);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, "dg100 config");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public void readProps(String string) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        this.logFormat = Byte.parseByte(properties.getProperty(propLogFormat, "2"));
        this.disableLogSpeed = Byte.parseByte(properties.getProperty(propDisableLogSpeed, "0"));
        this.speedThres = Integer.parseInt(properties.getProperty(propSpeedThres, "0"));
        this.disableLogDist = Byte.parseByte(properties.getProperty(propDisableLogDist, "0"));
        this.distThres = Integer.parseInt(properties.getProperty(propDistThres, "0"));
        this.swATime = Integer.parseInt(properties.getProperty(propSwATime, "1000"));
        this.swBTime = Integer.parseInt(properties.getProperty(propSwBTime, "1000"));
        this.swCTime = Integer.parseInt(properties.getProperty(propSwCTime, "1000"));
        this.swATimeOrDist = Byte.parseByte(properties.getProperty(propSwATimeOrDist, "0"));
        this.swBTimeOrDist = Byte.parseByte(properties.getProperty(propSwBTimeOrDist, "0"));
        this.swCTimeOrDist = Byte.parseByte(properties.getProperty(propSwCTimeOrDist, "0"));
        this.swADist = Integer.parseInt(properties.getProperty(propSwADist, "0"));
        this.swBDist = Integer.parseInt(properties.getProperty(propSwBDist, "0"));
        this.swCDist = Integer.parseInt(properties.getProperty(propSwCDist, "0"));
        this.unk1 = Short.parseShort(properties.getProperty(propUnk1, "0"));
        this.unk2 = Byte.parseByte(properties.getProperty(propUnk2, "0"));
        this.unk3 = Integer.parseInt(properties.getProperty(propUnk3, "0"));
        this.unk4 = Integer.parseInt(properties.getProperty(propUnk4, "0"));
    }
}

