/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackSize;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;

public enum Duplication implements StackManipulation
{
    ZERO(StackSize.ZERO, 0){

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return new StackManipulation.Size(0, 0);
        }
    }
    ,
    SINGLE(StackSize.SINGLE, 89),
    DOUBLE(StackSize.DOUBLE, 92);

    private final StackManipulation.Size size;
    private final int opcode;

    private Duplication(StackSize stackSize, int opcode) {
        this.size = stackSize.toIncreasingSize();
        this.opcode = opcode;
    }

    public static StackManipulation duplicate(TypeDescription typeDescription) {
        switch (typeDescription.getStackSize()) {
            case SINGLE: {
                return SINGLE;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case ZERO: {
                return ZERO;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return this.size;
    }

    public String toString() {
        return "Duplication." + this.name();
    }
}

