/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.inline;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;

public interface MethodNameTransformer {
    public String transform(MethodDescription var1);

    public static class Prefixing
    implements MethodNameTransformer {
        private static final String DEFAULT_PREFIX = "original";
        private final String prefix;

        public Prefixing() {
            this(DEFAULT_PREFIX);
        }

        public Prefixing(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String transform(MethodDescription methodDescription) {
            return String.format("%s%s", this.prefix, methodDescription.getInternalName());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((Prefixing)other).prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public String toString() {
            return "MethodNameTransformer.Prefixing{prefix='" + this.prefix + '\'' + '}';
        }
    }

    public static class Suffixing
    implements MethodNameTransformer {
        private static final String DEFAULT_SUFFIX = "original$";
        private final String suffix;

        public static MethodNameTransformer withRandomSuffix() {
            return new Suffixing(DEFAULT_SUFFIX + RandomString.make());
        }

        public Suffixing(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public String transform(MethodDescription methodDescription) {
            return String.format("%s$%s", methodDescription.getInternalName(), this.suffix);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((Suffixing)other).suffix);
        }

        public int hashCode() {
            return this.suffix.hashCode();
        }

        public String toString() {
            return "MethodNameTransformer.Suffixing{suffix='" + this.suffix + '\'' + '}';
        }
    }
}

