/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.ClassFileLocator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassReader;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassVisitor;

public class ClassFileVersion
implements Comparable<ClassFileVersion> {
    protected static final int BASE_VERSION = 44;
    public static final ClassFileVersion JAVA_V1 = new ClassFileVersion(196653);
    public static final ClassFileVersion JAVA_V2 = new ClassFileVersion(46);
    public static final ClassFileVersion JAVA_V3 = new ClassFileVersion(47);
    public static final ClassFileVersion JAVA_V4 = new ClassFileVersion(48);
    public static final ClassFileVersion JAVA_V5 = new ClassFileVersion(49);
    public static final ClassFileVersion JAVA_V6 = new ClassFileVersion(50);
    public static final ClassFileVersion JAVA_V7 = new ClassFileVersion(51);
    public static final ClassFileVersion JAVA_V8;
    public static final ClassFileVersion JAVA_V9;
    private static final VersionLocator VERSION_LOCATOR;
    private final int versionNumber;

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception not supposed to be rethrown")
    private static VersionLocator findVersionLocator() {
        try {
            Class<?> version = Class.forName("java.lang.Runtime$Version");
            return new VersionLocator.ForJava9CapableVm(version.getDeclaredMethod("current", new Class[0]), version.getDeclaredMethod("major", new Class[0]));
        }
        catch (Exception ignored) {
            return VersionLocator.ForLegacyVm.INSTANCE;
        }
    }

    protected ClassFileVersion(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public static ClassFileVersion ofMinorMajor(int versionNumber) {
        ClassFileVersion classFileVersion = new ClassFileVersion(versionNumber);
        if (classFileVersion.getMajorVersion() <= 44) {
            throw new IllegalArgumentException("Class version " + versionNumber + " is not valid");
        }
        return classFileVersion;
    }

    public static ClassFileVersion ofJavaVersion(int javaVersion) {
        switch (javaVersion) {
            case 1: {
                return JAVA_V1;
            }
            case 2: {
                return JAVA_V2;
            }
            case 3: {
                return JAVA_V3;
            }
            case 4: {
                return JAVA_V4;
            }
            case 5: {
                return JAVA_V5;
            }
            case 6: {
                return JAVA_V6;
            }
            case 7: {
                return JAVA_V7;
            }
            case 8: {
                return JAVA_V8;
            }
            case 9: {
                return JAVA_V9;
            }
        }
        throw new IllegalArgumentException("Unknown Java version: " + javaVersion);
    }

    public static ClassFileVersion forCurrentJavaVersion() {
        return VERSION_LOCATOR.findCurrentVersion();
    }

    public static ClassFileVersion of(Class<?> type) throws IOException {
        return ClassFileVersion.of(type, ClassFileLocator.ForClassLoader.of(type.getClassLoader()));
    }

    public static ClassFileVersion of(Class<?> type, ClassFileLocator classFileLocator) throws IOException {
        return ClassFileVersion.of(new TypeDescription.ForLoadedType(type), classFileLocator);
    }

    public static ClassFileVersion of(TypeDescription typeDescription, ClassFileLocator classFileLocator) throws IOException {
        ClassReader classReader = new ClassReader(classFileLocator.locate(typeDescription.getName()).resolve());
        VersionExtractor versionExtractor = new VersionExtractor();
        classReader.accept(versionExtractor, 1);
        return ClassFileVersion.ofMinorMajor(versionExtractor.getClassFileVersionNumber());
    }

    public int getMinorMajorVersion() {
        return this.versionNumber;
    }

    public int getMajorVersion() {
        return this.versionNumber & 0xFF;
    }

    public int getMinorVersion() {
        return this.versionNumber >> 16;
    }

    public int getJavaVersion() {
        return this.getMajorVersion() - 44;
    }

    public boolean isAtLeast(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) > -1;
    }

    public boolean isLessThan(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) < 0;
    }

    @Override
    public int compareTo(ClassFileVersion other) {
        return Integer.signum(this.getMajorVersion() == other.getMajorVersion() ? this.getMinorVersion() - other.getMinorVersion() : this.getMajorVersion() - other.getMajorVersion());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.versionNumber == ((ClassFileVersion)other).versionNumber;
    }

    public int hashCode() {
        return this.versionNumber;
    }

    public String toString() {
        return "ClassFileVersion{versionNumber=" + this.versionNumber + '}';
    }

    static {
        JAVA_V9 = JAVA_V8 = new ClassFileVersion(52);
        VERSION_LOCATOR = ClassFileVersion.findVersionLocator();
    }

    protected static class VersionExtractor
    extends ClassVisitor {
        private int classFileVersionNumber;

        protected VersionExtractor() {
            super(327680);
        }

        @Override
        public void visit(int classFileVersionNumber, int modifier, String internalName, String signature, String superTypeName, String[] interfaceName) {
            this.classFileVersionNumber = classFileVersionNumber;
        }

        protected int getClassFileVersionNumber() {
            return this.classFileVersionNumber;
        }

        public String toString() {
            return "ClassFileVersion.VersionExtractor{classFileVersionNumber=" + this.classFileVersionNumber + '}';
        }
    }

    protected static interface VersionLocator {
        public ClassFileVersion findCurrentVersion();

        public static enum ForLegacyVm implements VersionLocator,
        PrivilegedAction<String>
        {
            INSTANCE;

            private static final String JAVA_VERSION_PROPERTY = "java.version";

            @Override
            public ClassFileVersion findCurrentVersion() {
                String versionString = AccessController.doPrivileged(this);
                if (versionString.startsWith("9")) {
                    return JAVA_V9;
                }
                int[] versionIndex = new int[]{-1, 0, 0};
                for (int i = 1; i < 3; ++i) {
                    versionIndex[i] = versionString.indexOf(46, versionIndex[i - 1] + 1);
                    if (versionIndex[i] != -1) continue;
                    throw new IllegalStateException("This JVM's version string does not seem to be valid: " + versionString);
                }
                return ClassFileVersion.ofJavaVersion(Integer.parseInt(versionString.substring(versionIndex[1] + 1, versionIndex[2])));
            }

            @Override
            public String run() {
                return System.getProperty(JAVA_VERSION_PROPERTY);
            }

            public String toString() {
                return "ClassFileVersion.VersionLocator.ForLegacyVm." + this.name();
            }
        }

        public static class ForJava9CapableVm
        implements VersionLocator {
            private static final Object STATIC_METHOD = null;
            private final Method current;
            private final Method major;

            protected ForJava9CapableVm(Method current, Method major) {
                this.current = current;
                this.major = major;
            }

            @Override
            public ClassFileVersion findCurrentVersion() {
                try {
                    return ClassFileVersion.ofJavaVersion((Integer)this.major.invoke(this.current.invoke(STATIC_METHOD, new Object[0]), new Object[0]));
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Could not look up VM version", exception.getCause());
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Could not access VM version lookup", exception);
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForJava9CapableVm that = (ForJava9CapableVm)object;
                return this.current.equals(that.current) && this.major.equals(that.major);
            }

            public int hashCode() {
                int result = this.current.hashCode();
                result = 31 * result + this.major.hashCode();
                return result;
            }

            public String toString() {
                return "ClassFileVersion.VersionLocator.ForJava9CapableVm{current=" + this.current + ", major=" + this.major + '}';
            }
        }
    }
}

