/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;

public class FieldAccessor {
    private final Object object;
    private final Field field;

    public FieldAccessor(Object object, Field field) {
        this.object = object;
        this.field = field;
    }

    public Object getObject() {
        return this.object;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public boolean fieldIsPrimitive() {
        return this.getFieldType().isPrimitive();
    }

    public boolean fieldIsFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean fieldIsStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean fieldIsTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public boolean fieldIsSingleValueEnum() {
        Class<?> type = this.field.getType();
        return type.isEnum() && type.getEnumConstants().length == 1;
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Only called in test code, not production.")
    public Object get() {
        this.field.setAccessible(true);
        try {
            return this.field.get(this.object);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public void set(Object value) {
        this.modify(new FieldSetter(value), true);
    }

    public void defaultField() {
        this.modify(new FieldDefaulter(), false);
    }

    public void defaultStaticField() {
        this.modify(new FieldDefaulter(), true);
    }

    public void copyTo(Object to) {
        this.modify(new FieldCopier(to), false);
    }

    public void changeField(PrefabValues prefabValues, TypeTag enclosingType) {
        this.modify(new FieldChanger(prefabValues, enclosingType), false);
    }

    private void modify(FieldModifier modifier, boolean includeStatic) {
        if (!this.canBeModifiedReflectively()) {
            return;
        }
        if (!includeStatic && this.fieldIsStatic()) {
            return;
        }
        this.field.setAccessible(true);
        try {
            modifier.modify();
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public boolean canBeModifiedReflectively() {
        if (this.field.isSynthetic()) {
            return false;
        }
        int modifiers = this.field.getModifiers();
        return !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers);
    }

    private class FieldChanger
    implements FieldModifier {
        private final PrefabValues prefabValues;
        private final TypeTag enclosingType;

        public FieldChanger(PrefabValues prefabValues, TypeTag enclosingType) {
            this.prefabValues = prefabValues;
            this.enclosingType = enclosingType;
        }

        @Override
        public void modify() throws IllegalAccessException {
            Object newValue = this.prefabValues.giveOther(TypeTag.of(FieldAccessor.this.field, this.enclosingType), FieldAccessor.this.field.get(FieldAccessor.this.object));
            FieldAccessor.this.field.set(FieldAccessor.this.object, newValue);
        }
    }

    private class FieldCopier
    implements FieldModifier {
        private final Object to;

        public FieldCopier(Object to) {
            this.to = to;
        }

        @Override
        public void modify() throws IllegalAccessException {
            FieldAccessor.this.field.set(this.to, FieldAccessor.this.field.get(FieldAccessor.this.object));
        }
    }

    private class FieldDefaulter
    implements FieldModifier {
        private FieldDefaulter() {
        }

        @Override
        public void modify() throws IllegalAccessException {
            Class<?> type = FieldAccessor.this.field.getType();
            if (type == Boolean.TYPE) {
                FieldAccessor.this.field.setBoolean(FieldAccessor.this.object, false);
            } else if (type == Byte.TYPE) {
                FieldAccessor.this.field.setByte(FieldAccessor.this.object, (byte)0);
            } else if (type == Character.TYPE) {
                FieldAccessor.this.field.setChar(FieldAccessor.this.object, '\u0000');
            } else if (type == Double.TYPE) {
                FieldAccessor.this.field.setDouble(FieldAccessor.this.object, 0.0);
            } else if (type == Float.TYPE) {
                FieldAccessor.this.field.setFloat(FieldAccessor.this.object, 0.0f);
            } else if (type == Integer.TYPE) {
                FieldAccessor.this.field.setInt(FieldAccessor.this.object, 0);
            } else if (type == Long.TYPE) {
                FieldAccessor.this.field.setLong(FieldAccessor.this.object, 0L);
            } else if (type == Short.TYPE) {
                FieldAccessor.this.field.setShort(FieldAccessor.this.object, (short)0);
            } else {
                FieldAccessor.this.field.set(FieldAccessor.this.object, null);
            }
        }
    }

    private class FieldSetter
    implements FieldModifier {
        private final Object newValue;

        public FieldSetter(Object newValue) {
            this.newValue = newValue;
        }

        @Override
        public void modify() throws IllegalAccessException {
            FieldAccessor.this.field.set(FieldAccessor.this.object, this.newValue);
        }
    }

    private static interface FieldModifier {
        public void modify() throws IllegalAccessException;
    }
}

