/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.internal.Assert;
import nl.jqno.equalsverifier.internal.FieldIterable;
import nl.jqno.equalsverifier.internal.Formatter;
import nl.jqno.equalsverifier.internal.ObjectAccessor;
import nl.jqno.equalsverifier.internal.exceptions.AssertionException;

class ExamplesChecker<T>
implements Checker {
    private final Class<T> type;
    private final List<T> equalExamples;
    private final List<T> unequalExamples;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public ExamplesChecker(Configuration<T> config) {
        this.type = config.getType();
        this.equalExamples = config.getEqualExamples();
        this.unequalExamples = config.getUnequalExamples();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkPreconditions();
        for (int i = 0; i < this.equalExamples.size(); ++i) {
            T reference = this.equalExamples.get(i);
            this.checkSingle(reference);
            for (int j = i + 1; j < this.equalExamples.size(); ++j) {
                T other = this.equalExamples.get(j);
                this.checkEqualButNotIdentical(reference, other);
                this.checkHashCode(reference, other);
            }
        }
        for (T reference : this.unequalExamples) {
            this.checkSingle(reference);
        }
    }

    private void checkPreconditions() {
        for (T example : this.equalExamples) {
            Assert.assertTrue(Formatter.of("Precondition:\n  %%\nand\n  %%\nare of different classes", this.equalExamples.get(0), example), this.type.isAssignableFrom(example.getClass()));
        }
    }

    private void checkEqualButNotIdentical(T reference, T other) {
        Assert.assertFalse(Formatter.of("Precondition: the same object appears twice:\n  %%", reference), reference == other);
        Assert.assertFalse(Formatter.of("Precondition: two identical objects appear:\n  %%", reference), this.isIdentical(reference, other));
        Assert.assertTrue(Formatter.of("Precondition: not all equal objects are equal:\n  %%\nand\n  %%", reference, other), reference.equals(other));
    }

    private void checkSingle(T reference) {
        T copy = ObjectAccessor.of(reference, this.type).copy();
        this.checkReflexivity(reference);
        this.checkNonNullity(reference);
        this.checkTypeCheck(reference);
        this.checkHashCode(reference, copy);
    }

    private void checkReflexivity(T reference) {
        Assert.assertEquals(Formatter.of("Reflexivity: object does not equal itself:\n  %%", reference), reference, reference);
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"}, justification="Check what happens when null is passed into equals.")
    private void checkNonNullity(T reference) {
        try {
            boolean nullity = reference.equals(null);
            Assert.assertFalse(Formatter.of("Non-nullity: true returned for null value", new Object[0]), nullity);
        }
        catch (NullPointerException e) {
            Assert.fail(Formatter.of("Non-nullity: NullPointerException thrown", new Object[0]), e);
        }
    }

    private void checkTypeCheck(T reference) {
        class SomethingElse {
            SomethingElse() {
            }
        }
        SomethingElse somethingElse = new SomethingElse();
        try {
            Assert.assertFalse(Formatter.of("Type-check: equals returns true for an unrelated type.\nAdd an instanceof or getClass() check.", new Object[0]), reference.equals(somethingElse));
        }
        catch (AssertionException e) {
            throw e;
        }
        catch (ClassCastException e) {
            Assert.fail(Formatter.of("Type-check: equals throws ClassCastException.\nAdd an instanceof or getClass() check.", new Object[0]), e);
        }
        catch (Exception e) {
            Assert.fail(Formatter.of("Type-check: equals throws %%.\nAdd an instanceof or getClass() check.", e.getClass().getSimpleName()), e);
        }
    }

    private void checkHashCode(T reference, T copy) {
        int referenceHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
        Assert.assertEquals(Formatter.of("hashCode: hashCode should be consistent:\n  %% (%%)", reference, referenceHashCode), referenceHashCode, this.cachedHashCodeInitializer.getInitializedHashCode(reference));
        if (!reference.equals(copy)) {
            return;
        }
        int copyHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(copy);
        Formatter f = Formatter.of("hashCode: hashCodes should be equal:\n  %% (%%)\nand\n  %% (%%)", reference, referenceHashCode, copy, copyHashCode);
        Assert.assertEquals(f, referenceHashCode, copyHashCode);
    }

    private boolean isIdentical(T reference, T other) {
        for (Field field : FieldIterable.of(reference.getClass())) {
            try {
                field.setAccessible(true);
                if (Objects.equals(field.get(reference), field.get(other))) continue;
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

