/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.util.CheckSignatureAdapter;
import org.objectweb.asm.util.TraceSignatureVisitorUnitTest;

public class CheckSignatureAdapterUnitTest
extends TestCase {
    private TraceSignatureVisitorUnitTest.TestData data;
    private SignatureVisitor sv;

    public static TestSuite suite() {
        TestSuite suite = new TestSuite(CheckSignatureAdapterUnitTest.class.getName());
        int i = 0;
        while (i < TraceSignatureVisitorUnitTest.DATA.length) {
            suite.addTest((Test)new CheckSignatureAdapterUnitTest(new TraceSignatureVisitorUnitTest.TestData(TraceSignatureVisitorUnitTest.DATA[i])));
            ++i;
        }
        suite.addTestSuite(CheckSignatureAdapterUnitTest.class);
        return suite;
    }

    public CheckSignatureAdapterUnitTest() {
    }

    private CheckSignatureAdapterUnitTest(TraceSignatureVisitorUnitTest.TestData data) {
        super("checkSignature");
        this.data = data;
    }

    public void checkSignature() {
        SignatureWriter wrt = new SignatureWriter();
        SignatureReader rdr = new SignatureReader(this.data.signature);
        switch (this.data.type) {
            case 'C': {
                rdr.accept(new CheckSignatureAdapter(0, wrt));
                break;
            }
            case 'M': {
                rdr.accept(new CheckSignatureAdapter(1, wrt));
                break;
            }
            case 'F': {
                rdr.acceptType(new CheckSignatureAdapter(2, wrt));
                break;
            }
            default: {
                return;
            }
        }
        CheckSignatureAdapterUnitTest.assertEquals((String)this.data.signature, (String)wrt.toString());
    }

    public void testIllegalFormalTypeParam() {
        this.setup(2);
        try {
            this.sv.visitFormalTypeParameter("T");
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassBound() {
        this.setup(0);
        try {
            this.sv.visitClassBound();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalInterfaceBound() {
        this.setup(0);
        try {
            this.sv.visitInterfaceBound();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalSuperclass() {
        this.setup(1);
        try {
            this.sv.visitSuperclass();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalInterface() {
        this.setup(0);
        try {
            this.sv.visitInterface();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalParameterType() {
        this.setup(0);
        try {
            this.sv.visitParameterType();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalReturnType() {
        this.setup(1);
        try {
            this.sv.visitReturnType();
            this.sv.visitReturnType();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalExceptionType() {
        this.setup(1);
        try {
            this.sv.visitExceptionType();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalBaseType() {
        this.setup(2);
        try {
            this.sv.visitBaseType('I');
            this.sv.visitBaseType('I');
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setup(2);
        try {
            this.sv.visitBaseType('V');
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setup(2);
        try {
            this.sv.visitBaseType('A');
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTypeVariable() {
        this.setup(2);
        try {
            this.sv.visitTypeVariable("T");
            this.sv.visitTypeVariable("T");
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalArrayType() {
        this.setup(2);
        try {
            this.sv.visitArrayType();
            this.sv.visitArrayType();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassType() {
        this.setup(2);
        try {
            this.sv.visitClassType("A");
            this.sv.visitClassType("A");
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalInnerClassType() {
        this.setup(2);
        try {
            this.sv.visitInnerClassType("A");
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTypeArgument() {
        this.setup(2);
        try {
            this.sv.visitTypeArgument();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setup(2);
        try {
            this.sv.visitTypeArgument('+');
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setup(2);
        try {
            this.sv.visitClassType("A");
            this.sv.visitTypeArgument('*');
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalEnd() {
        this.setup(2);
        try {
            this.sv.visitEnd();
            CheckSignatureAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        if (this.data == null) {
            return super.getName();
        }
        return String.valueOf(super.getName()) + " " + this.data.signature;
    }

    private void setup(int type) {
        this.sv = new CheckSignatureAdapter(type, null);
    }
}

