/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import junit.framework.TestCase;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.attrs.Comment;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.CheckFieldAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;

public class CheckClassAdapterUnitTest
extends TestCase
implements Opcodes {
    public void testCheckClassVisitor() throws Exception {
        String s = this.getClass().getName();
        CheckClassAdapter.main(new String[0]);
        CheckClassAdapter.main(new String[]{s});
        CheckClassAdapter.main(new String[]{"output/test/cases/Interface.class"});
    }

    public void testVerifyValidClass() throws Exception {
        ClassReader cr = new ClassReader(this.getClass().getName());
        CheckClassAdapter.verify(cr, true, new PrintWriter(System.err));
    }

    public void testVerifyInvalidClass() {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(196653, 1, "C", null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "m", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(54, 30);
        mv.visitInsn(177);
        mv.visitMaxs(1, 31);
        mv.visitEnd();
        cw.visitEnd();
        ClassReader cr = new ClassReader(cw.toByteArray());
        CheckClassAdapter.verify(cr, true, new PrintWriter(System.err));
    }

    public void testIllegalClassAccessFlag() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        try {
            ((ClassVisitor)cv).visit(196653, 0x100000, "C", null, "java/lang/Object", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalSuperClass() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        try {
            ((ClassVisitor)cv).visit(196653, 1, "java/lang/Object", null, "java/lang/Object", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalInterfaceSuperClass() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        try {
            ((ClassVisitor)cv).visit(196653, 512, "I", null, "C", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassSignature() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        try {
            ((ClassVisitor)cv).visit(196653, 1, "C", "LC;I", "java/lang/Object", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassAccessFlagSet() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        try {
            ((ClassVisitor)cv).visit(196653, 1040, "C", null, "java/lang/Object", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassMemberVisitBeforeStart() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        try {
            ((ClassVisitor)cv).visitSource(null, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassAttribute() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        try {
            ((ClassVisitor)cv).visitAttribute(null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMultipleVisitCalls() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        try {
            ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMultipleVisitSourceCalls() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        ((ClassVisitor)cv).visitSource(null, null);
        try {
            ((ClassVisitor)cv).visitSource(null, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalOuterClassName() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        try {
            ((ClassVisitor)cv).visitOuterClass(null, null, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMultipleVisitOuterClassCalls() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        ((ClassVisitor)cv).visitOuterClass("name", null, null);
        try {
            ((ClassVisitor)cv).visitOuterClass(null, null, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldAccessFlagSet() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        try {
            ((ClassVisitor)cv).visitField(3, "i", "I", null, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldSignature() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        try {
            ((ClassVisitor)cv).visitField(1, "i", "I", "L;", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ClassVisitor)cv).visitField(1, "i", "I", "LC+", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ClassVisitor)cv).visitField(1, "i", "I", "LC;I", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalClassMemberVisitAfterEnd() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        ((ClassVisitor)cv).visitEnd();
        try {
            ((ClassVisitor)cv).visitSource(null, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldMemberVisitAfterEnd() {
        CheckFieldAdapter fv = new CheckFieldAdapter(null);
        ((FieldVisitor)fv).visitEnd();
        try {
            ((FieldVisitor)fv).visitAttribute(new Comment());
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldAttribute() {
        CheckFieldAdapter fv = new CheckFieldAdapter(null);
        try {
            ((FieldVisitor)fv).visitAttribute(null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalAnnotationDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        try {
            ((MethodVisitor)mv).visitParameterAnnotation(0, "'", true);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalAnnotationName() {
        CheckAnnotationAdapter av = new CheckAnnotationAdapter(null);
        try {
            ((AnnotationVisitor)av).visit(null, new Integer(0));
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalAnnotationValue() {
        CheckAnnotationAdapter av = new CheckAnnotationAdapter(null);
        try {
            ((AnnotationVisitor)av).visit("name", new Object());
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalAnnotationEnumValue() {
        CheckAnnotationAdapter av = new CheckAnnotationAdapter(null);
        try {
            ((AnnotationVisitor)av).visitEnum("name", "Lpkg/Enum;", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalAnnotationValueAfterEnd() {
        CheckAnnotationAdapter av = new CheckAnnotationAdapter(null);
        ((AnnotationVisitor)av).visitEnd();
        try {
            ((AnnotationVisitor)av).visit("name", new Integer(0));
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodMemberVisitAfterEnd() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitEnd();
        try {
            ((MethodVisitor)mv).visitAttribute(new Comment());
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodAttribute() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        try {
            ((MethodVisitor)mv).visitAttribute(null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodSignature() {
        CheckClassAdapter cv = new CheckClassAdapter(null);
        ((ClassVisitor)cv).visit(196653, 1, "C", null, "java/lang/Object", null);
        try {
            ((ClassVisitor)cv).visitMethod(1, "m", "()V", "<T::LI.J<*+LA;>;>()V^LA;X", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnVisitBeforeStart() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        try {
            ((MethodVisitor)mv).visitInsn(0);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFrameType() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFrame(123, 0, null, 0, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFrameLocalCount() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFrame(3, 1, new Object[]{INTEGER}, 0, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFrameStackCount() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFrame(3, 0, null, 1, new Object[]{INTEGER});
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFrameLocalArray() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFrame(1, 1, new Object[0], 0, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFrameStackArray() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFrame(4, 0, null, 1, new Object[0]);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFrameValue() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFrame(0, 1, new Object[]{"LC;"}, 0, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((MethodVisitor)mv).visitFrame(0, 1, new Object[]{new Integer(0)}, 0, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsn() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitInsn(-1);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalByteInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitIntInsn(16, Integer.MAX_VALUE);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalShortInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitIntInsn(17, Integer.MAX_VALUE);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalVarInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitVarInsn(25, -1);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalIntInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitIntInsn(188, 0);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTypeInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitTypeInsn(187, "[I");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLabelInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        Label l = new Label();
        ((MethodVisitor)mv).visitLabel(l);
        try {
            ((MethodVisitor)mv).visitLabel(l);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalDebugLabelUse() throws IOException {
        ClassReader cr = new ClassReader("java.lang.Object");
        ClassWriter cw = new ClassWriter(cr, 1);
        ClassVisitor cv = new ClassVisitor(327680, cw){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor next = this.cv.visitMethod(access, name, desc, signature, exceptions);
                if (next == null) {
                    return next;
                }
                return new MethodVisitor(327680, new CheckMethodAdapter(next)){
                    private Label entryLabel;
                    {
                        this.entryLabel = null;
                    }

                    public void visitLabel(Label label) {
                        if (this.entryLabel == null) {
                            this.entryLabel = label;
                        }
                        this.mv.visitLabel(label);
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                        Label unwindhandler = new Label();
                        this.mv.visitLabel(unwindhandler);
                        this.mv.visitInsn(191);
                        this.mv.visitTryCatchBlock(this.entryLabel, unwindhandler, unwindhandler, null);
                        this.mv.visitMaxs(maxStack, maxLocals);
                    }
                };
            }
        };
        try {
            cr.accept(cv, 8);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTableSwitchParameters1() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitTableSwitchInsn(1, 0, new Label(), new Label[0]);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTableSwitchParameters2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitTableSwitchInsn(0, 1, null, new Label[0]);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTableSwitchParameters3() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitTableSwitchInsn(0, 1, new Label(), null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTableSwitchParameters4() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitTableSwitchInsn(0, 1, new Label(), new Label[0]);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLookupSwitchParameters1() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitLookupSwitchInsn(new Label(), null, new Label[0]);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLookupSwitchParameters2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitLookupSwitchInsn(new Label(), new int[0], null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLookupSwitchParameters3() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitLookupSwitchInsn(new Label(), new int[0], new Label[1]);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnNullOwner() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, null, "i", "I");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnOwner() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "-", "i", "I");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnNullName() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", null, "I");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnName() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "-", "I");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnName2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "a-", "I");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnNullDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "i", null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnVoidDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "i", "V");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnPrimitiveDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "i", "II");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnArrayDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "i", "[");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnReferenceDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "i", "L");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalFieldInsnReferenceDesc2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitFieldInsn(180, "C", "i", "L-;");
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnNullName() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", null, "()V", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnName() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "-", "()V", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnName2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "a-", "()V", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnNullDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "m", null, false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "m", "I", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnParameterDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "m", "(V)V", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnReturnDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "m", "()VV", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnItf() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(185, "C", "m", "()V", false);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMethodInsnItf2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMethodInsn(182, "C", "m", "()V", true);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLdcInsnOperand() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitLdcInsn(new Object());
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMultiANewArrayDesc() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMultiANewArrayInsn("I", 1);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMultiANewArrayDims() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMultiANewArrayInsn("[[I", 0);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalMultiANewArrayDims2() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitMultiANewArrayInsn("[[I", 3);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalTryCatchBlock() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        Label m = new Label();
        Label n = new Label();
        ((MethodVisitor)mv).visitLabel(m);
        try {
            ((MethodVisitor)mv).visitTryCatchBlock(m, n, n, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((MethodVisitor)mv).visitTryCatchBlock(n, m, n, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((MethodVisitor)mv).visitTryCatchBlock(n, n, m, null);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalDataflow() {
        CheckMethodAdapter mv = new CheckMethodAdapter(1, "m", "(I)V", null, new HashMap<Label, Integer>());
        ((MethodVisitor)mv).visitCode();
        ((MethodVisitor)mv).visitVarInsn(21, 1);
        ((MethodVisitor)mv).visitInsn(172);
        ((MethodVisitor)mv).visitMaxs(1, 2);
        try {
            ((MethodVisitor)mv).visitEnd();
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalDataflobjectweb() {
        CheckMethodAdapter mv = new CheckMethodAdapter(1, "m", "(I)I", null, new HashMap<Label, Integer>());
        ((MethodVisitor)mv).visitCode();
        ((MethodVisitor)mv).visitInsn(177);
        ((MethodVisitor)mv).visitMaxs(0, 2);
        try {
            ((MethodVisitor)mv).visitEnd();
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLocalVariableLabels() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        Label m = new Label();
        Label n = new Label();
        ((MethodVisitor)mv).visitLabel(n);
        ((MethodVisitor)mv).visitInsn(0);
        ((MethodVisitor)mv).visitLabel(m);
        try {
            ((MethodVisitor)mv).visitLocalVariable("i", "I", null, m, n, 0);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalLineNumerLabel() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        try {
            ((MethodVisitor)mv).visitLineNumber(0, new Label());
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIllegalInsnVisitAfterEnd() {
        CheckMethodAdapter mv = new CheckMethodAdapter(null);
        ((MethodVisitor)mv).visitCode();
        ((MethodVisitor)mv).visitMaxs(0, 0);
        try {
            ((MethodVisitor)mv).visitInsn(0);
            CheckClassAdapterUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

