/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import junit.framework.TestCase;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassNodeUnitTest
extends TestCase
implements Opcodes {
    public void testFrameNode() {
        FrameNode fn = new FrameNode(3, 0, null, 0, null);
        ClassNodeUnitTest.assertEquals((int)14, (int)fn.getType());
    }

    public void testInsnNode() {
        InsnNode in = new InsnNode(0);
        ClassNodeUnitTest.assertEquals((int)in.getOpcode(), (int)0);
        ClassNodeUnitTest.assertEquals((int)0, (int)in.getType());
    }

    public void testIntInsnNode() {
        IntInsnNode iin = new IntInsnNode(16, 0);
        iin.setOpcode(17);
        ClassNodeUnitTest.assertEquals((int)17, (int)iin.getOpcode());
        ClassNodeUnitTest.assertEquals((int)1, (int)iin.getType());
    }

    public void testVarInsnNode() {
        VarInsnNode vn = new VarInsnNode(25, 0);
        vn.setOpcode(58);
        ClassNodeUnitTest.assertEquals((int)58, (int)vn.getOpcode());
        ClassNodeUnitTest.assertEquals((int)2, (int)vn.getType());
    }

    public void testTypeInsnNode() {
        TypeInsnNode tin = new TypeInsnNode(187, "java/lang/Object");
        tin.setOpcode(192);
        ClassNodeUnitTest.assertEquals((int)192, (int)tin.getOpcode());
        ClassNodeUnitTest.assertEquals((int)3, (int)tin.getType());
    }

    public void testFieldInsnNode() {
        FieldInsnNode fn = new FieldInsnNode(178, "owner", "name", "I");
        fn.setOpcode(179);
        ClassNodeUnitTest.assertEquals((int)179, (int)fn.getOpcode());
        ClassNodeUnitTest.assertEquals((int)4, (int)fn.getType());
    }

    public void testMethodInsnNode() {
        MethodInsnNode mn = new MethodInsnNode(184, "owner", "name", "I", false);
        mn.setOpcode(183);
        ClassNodeUnitTest.assertEquals((int)183, (int)mn.getOpcode());
        ClassNodeUnitTest.assertEquals((int)5, (int)mn.getType());
    }

    public void testInvokeDynamicInsnNode() {
        Handle bsm = new Handle(6, "owner", "name", "()V", false);
        InvokeDynamicInsnNode mn = new InvokeDynamicInsnNode("name", "()V", bsm, new Object[0]);
        ClassNodeUnitTest.assertEquals((int)186, (int)mn.getOpcode());
        ClassNodeUnitTest.assertEquals((int)6, (int)mn.getType());
    }

    public void testJumpInsnNode() {
        JumpInsnNode jn = new JumpInsnNode(167, new LabelNode());
        jn.setOpcode(153);
        ClassNodeUnitTest.assertEquals((int)153, (int)jn.getOpcode());
        ClassNodeUnitTest.assertEquals((int)7, (int)jn.getType());
    }

    public void testLabelNode() {
        LabelNode ln = new LabelNode();
        ClassNodeUnitTest.assertEquals((int)8, (int)ln.getType());
        ClassNodeUnitTest.assertTrue((ln.getLabel() != null ? 1 : 0) != 0);
        ln.getLabel().info = new Object();
    }

    public void testIincInsnNode() {
        IincInsnNode iincn = new IincInsnNode(1, 1);
        ClassNodeUnitTest.assertEquals((int)10, (int)iincn.getType());
    }

    public void testLdcInsnNode() {
        LdcInsnNode ldcn = new LdcInsnNode("s");
        ClassNodeUnitTest.assertEquals((int)9, (int)ldcn.getType());
    }

    public void testLookupSwitchInsnNode() {
        LookupSwitchInsnNode lsn = new LookupSwitchInsnNode(null, null, null);
        ClassNodeUnitTest.assertEquals((int)12, (int)lsn.getType());
    }

    public void testTableSwitchInsnNode() {
        TableSwitchInsnNode tsn = new TableSwitchInsnNode(0, 1, null, null);
        ClassNodeUnitTest.assertEquals((int)11, (int)tsn.getType());
    }

    public void testMultiANewArrayInsnNode() {
        MultiANewArrayInsnNode manan = new MultiANewArrayInsnNode("[[I", 2);
        ClassNodeUnitTest.assertEquals((int)13, (int)manan.getType());
    }

    public void testCloneMethod() {
        MethodNode n = new MethodNode();
        Label l0 = new Label();
        Label l1 = new Label();
        n.visitCode();
        n.visitLabel(l0);
        n.visitInsn(0);
        n.visitLabel(l1);
        n.visitEnd();
        MethodNode n1 = new MethodNode();
        n.accept(n1);
        n.accept(n1);
    }
}

