/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.signature;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.util.TraceSignatureVisitorUnitTest;

public class SignatureUnitTest
extends TestCase {
    private TraceSignatureVisitorUnitTest.TestData data;

    public static TestSuite suite() {
        TestSuite suite = new TestSuite(SignatureUnitTest.class.getName());
        int i = 0;
        while (i < TraceSignatureVisitorUnitTest.DATA.length) {
            suite.addTest((Test)new SignatureUnitTest(new TraceSignatureVisitorUnitTest.TestData(TraceSignatureVisitorUnitTest.DATA[i])));
            ++i;
        }
        return suite;
    }

    private SignatureUnitTest(TraceSignatureVisitorUnitTest.TestData data) {
        super("testSignature");
        this.data = data;
    }

    public void testSignature() {
        SignatureWriter wrt = new SignatureWriter();
        SignatureReader rdr = new SignatureReader(this.data.signature);
        switch (this.data.type) {
            case 'C': 
            case 'M': {
                rdr.accept(wrt);
                break;
            }
            case 'F': {
                rdr.acceptType(wrt);
                break;
            }
            default: {
                return;
            }
        }
        SignatureUnitTest.assertEquals((String)this.data.signature, (String)wrt.toString());
    }

    public String getName() {
        return String.valueOf(super.getName()) + " " + this.data.signature;
    }
}

