/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import junit.framework.TestCase;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.StaticInitMerger;

public class StaticInitMergerTest
extends TestCase
implements Opcodes {
    private static final TestClassLoader LOADER = new TestClassLoader();

    public void test() throws Exception {
        ClassWriter cw = new ClassWriter(1);
        StaticInitMerger cv = new StaticInitMerger("$clinit$", (ClassVisitor)cw);
        ((ClassVisitor)cv).visit(196653, 1, "A", null, "java/lang/Object", null);
        cv.visitField(9, "counter", "I", null, null);
        int i = 0;
        while (i < 5) {
            MethodVisitor mv = ((ClassVisitor)cv).visitMethod(1, "<clinit>", "()V", null, null);
            mv.visitFieldInsn(178, "A", "counter", "I");
            mv.visitInsn(4);
            mv.visitInsn(96);
            mv.visitFieldInsn(179, "A", "counter", "I");
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            ++i;
        }
        MethodVisitor mv = ((ClassVisitor)cv).visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        ((ClassVisitor)cv).visitEnd();
        Class<?> c = LOADER.defineClass("A", cw.toByteArray());
        StaticInitMergerTest.assertEquals((int)c.getField("counter").getInt(c.newInstance()), (int)5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

