/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.objectweb.asm.commons.SimpleRemapper;

public class SignatureRemapperUnitTest
extends TestCase {
    public static void testRemappingParentOnlyNestedClassExtends() {
        SimpleRemapper remapper = new SimpleRemapper(Collections.singletonMap("Outer", "RenamedOuter"));
        SignatureRemapperUnitTest.assertEquals((String)"LRenamedOuter<Ljava/lang/Object;>.Inner;", (String)remapper.mapSignature("LOuter<Ljava/lang/Object;>.Inner;", false));
    }

    public static void testRemappingChildOnlyNestedClassExtends() {
        SimpleRemapper remapper = new SimpleRemapper(Collections.singletonMap("Outer$Inner", "Outer$RenamedInner"));
        SignatureRemapperUnitTest.assertEquals((String)"LOuter<Ljava/lang/Object;>.RenamedInner;", (String)remapper.mapSignature("LOuter<Ljava/lang/Object;>.Inner;", false));
    }

    public static void testRemappingBothParentAndChildNestedClassExtends() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("Outer", "RenamedOuter");
        mapping.put("Outer$Inner", "RenamedOuter$RenamedInner");
        SimpleRemapper remapper = new SimpleRemapper(mapping);
        SignatureRemapperUnitTest.assertEquals((String)"LRenamedOuter<Ljava/lang/Object;>.RenamedInner;", (String)remapper.mapSignature("LOuter<Ljava/lang/Object;>.Inner;", false));
    }
}

