/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.TestSuite;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.attrs.CodeComment;
import org.objectweb.asm.attrs.Comment;
import org.objectweb.asm.commons.GASMifier;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.util.TraceClassVisitor;

public class GASMifierTest
extends AbstractTest {
    public static final Compiler COMPILER = new Compiler();
    private static final TestClassLoader LOADER = new TestClassLoader();

    public static TestSuite suite() throws Exception {
        return new GASMifierTest().getSuite();
    }

    public void test() throws Exception {
        byte[] b;
        byte[] generatorClassData;
        ClassReader cr = new ClassReader(this.is);
        if (cr.b.length > 20000) {
            return;
        }
        StringWriter sw = new StringWriter();
        TraceClassVisitor cv = new TraceClassVisitor(null, new GASMifier(), new PrintWriter(sw));
        cr.accept(new ClassLocalVariablesSorter(cv), new Attribute[]{new Comment(), new CodeComment()}, 8);
        String generated = sw.toString();
        try {
            generatorClassData = COMPILER.compile(this.n, generated);
        }
        catch (Exception ex) {
            this.trace(generated);
            throw ex;
        }
        ClassWriter cw = new ClassWriter(0);
        cr.accept(new ClassLocalVariablesSorter(cw), new Attribute[]{new Comment(), new CodeComment()}, 8);
        cr = new ClassReader(cw.toByteArray());
        String nd = String.valueOf(this.n) + "Dump";
        if (this.n.indexOf(46) != -1) {
            nd = "asm." + nd;
        }
        Class<?> c = LOADER.defineClass(nd, generatorClassData);
        Method m = c.getMethod("dump", new Class[0]);
        try {
            b = (byte[])m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            this.trace(generated);
            throw (Exception)ex.getTargetException();
        }
        try {
            this.assertEquals(cr, new ClassReader(b), new Filter(), new Filter());
        }
        catch (Throwable e) {
            this.trace(generated);
            this.assertEquals(cr, new ClassReader(b), new Filter(), new Filter());
        }
    }

    private void trace(String generated) {
        if (System.getProperty("asm.test.class") != null) {
            System.err.println(generated);
        }
    }

    static class ClassLocalVariablesSorter
    extends ClassVisitor {
        public ClassLocalVariablesSorter(ClassVisitor cv) {
            super(327680, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new LocalVariablesSorter(access, desc, super.visitMethod(access, name, desc, signature, exceptions));
        }
    }

    static class Compiler {
        static final IClassLoader CL = new ClassLoaderIClassLoader((ClassLoader)new URLClassLoader(new URL[0]));

        Compiler() {
        }

        public byte[] compile(String name, String source) throws Exception {
            Parser p = new Parser(new Scanner(name, (Reader)new StringReader(source)));
            UnitCompiler uc = new UnitCompiler(p.parseCompilationUnit(), CL);
            return uc.compileUnit(DebuggingInformation.ALL)[0].toByteArray();
        }
    }

    static class Filter
    extends ClassVisitor {
        public Filter() {
            super(327680);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                public void visitMaxs(int maxStack, int maxLocals) {
                    super.visitMaxs(0, 0);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

