/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class GASMifier
extends ASMifier
implements Opcodes {
    int access;
    Type[] argumentTypes;
    int firstLocal;
    Map<Integer, Integer> locals;
    List<String> localTypes;

    public GASMifier() {
        super(327680, "cw", 0);
    }

    public GASMifier(String name, int id) {
        super(327680, name, id);
    }

    public GASMifier(int access, String desc) {
        super(327680, "mg", 0);
        this.access = access;
        this.argumentTypes = Type.getArgumentTypes(desc);
        int nextLocal = (8 & access) != 0 ? 0 : 1;
        int i = 0;
        while (i < this.argumentTypes.length) {
            nextLocal += this.argumentTypes[i].getSize();
            ++i;
        }
        this.firstLocal = nextLocal;
        this.locals = new HashMap<Integer, Integer>();
        this.localTypes = new ArrayList<String>();
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        int flags = 2;
        boolean ok = true;
        if (args.length < 1 || args.length > 2) {
            ok = false;
        }
        if (ok && args[0].equals("-debug")) {
            i = 1;
            flags = 0;
            if (args.length != 2) {
                ok = false;
            }
        }
        if (!ok) {
            System.err.println("Prints the ASM code to generate the given class.");
            System.err.println("Usage: GASMifierClassVisitor [-debug] <fully qualified class name or class file name>");
            System.exit(-1);
        }
        ClassReader cr = args[i].endsWith(".class") ? new ClassReader(new FileInputStream(args[i])) : new ClassReader(args[i]);
        cr.accept(new TraceClassVisitor(null, new GASMifier(), new PrintWriter(System.out)), 8 | flags);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        int n = name.lastIndexOf(47) != -1 ? 1 : 0;
        this.text.set(n + 5, "ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_MAXS);\n");
        this.text.set(n + 7, "TestGeneratorAdapter mg;\n");
        this.text.add(n + 1, "import org.objectweb.asm.commons.*;\n");
    }

    public ASMifier visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        this.buf.append("mg = new TestGeneratorAdapter(");
        this.buf.append(access);
        this.buf.append(", ");
        this.buf.append(GASMifier.getMethod(name, desc));
        this.buf.append(", ");
        if (signature == null) {
            this.buf.append("null");
        } else {
            this.buf.append('\"').append(signature).append('\"');
        }
        this.buf.append(", ");
        if (exceptions != null && exceptions.length > 0) {
            this.buf.append("new Type[] {");
            int i = 0;
            while (i < exceptions.length) {
                this.buf.append(i == 0 ? " " : ", ");
                this.buf.append(GASMifier.getType(exceptions[i]));
                ++i;
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(", cw);\n");
        this.text.add(this.buf.toString());
        GASMifier av = new GASMifier(access, desc);
        this.text.add(av.getText());
        this.text.add("}\n");
        return av;
    }

    public void visitInsn(int opcode) {
        this.buf.setLength(0);
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                this.buf.append("mg.returnValue();\n");
                break;
            }
            case 0: {
                this.buf.append("mg.visitInsn(Opcodes.NOP);\n");
                break;
            }
            case 1: {
                this.buf.append("mg.push((String)null);\n");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.buf.append("mg.push(").append(opcode - 3).append(");\n");
                break;
            }
            case 9: 
            case 10: {
                this.buf.append("mg.push(").append(opcode - 9).append("L);\n");
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.buf.append("mg.push(").append(opcode - 11).append("f);\n");
                break;
            }
            case 14: 
            case 15: {
                this.buf.append("mg.push(").append(opcode - 14).append("d);\n");
                break;
            }
            case 87: {
                this.buf.append("mg.pop();\n");
                break;
            }
            case 88: {
                this.buf.append("mg.pop2();\n");
                break;
            }
            case 89: {
                this.buf.append("mg.dup();\n");
                break;
            }
            case 90: {
                this.buf.append("mg.dupX1();\n");
                break;
            }
            case 91: {
                this.buf.append("mg.dupX2();\n");
                break;
            }
            case 92: {
                this.buf.append("mg.dup2();\n");
                break;
            }
            case 93: {
                this.buf.append("mg.dup2X1();\n");
                break;
            }
            case 94: {
                this.buf.append("mg.dup2X2();\n");
                break;
            }
            case 95: {
                this.buf.append("mg.swap();\n");
                break;
            }
            case 194: {
                this.buf.append("mg.monitorEnter();\n");
                break;
            }
            case 195: {
                this.buf.append("mg.monitorExit();\n");
                break;
            }
            case 190: {
                this.buf.append("mg.arrayLength();\n");
                break;
            }
            case 46: {
                this.buf.append("mg.arrayLoad(Type.INT_TYPE);\n");
                break;
            }
            case 47: {
                this.buf.append("mg.arrayLoad(Type.LONG_TYPE);\n");
                break;
            }
            case 48: {
                this.buf.append("mg.arrayLoad(Type.FLOAT_TYPE);\n");
                break;
            }
            case 49: {
                this.buf.append("mg.arrayLoad(Type.DOUBLE_TYPE);\n");
                break;
            }
            case 50: {
                this.buf.append("mg.arrayLoad(" + GASMifier.getType("java/lang/Object") + ");\n");
                break;
            }
            case 51: {
                this.buf.append("mg.arrayLoad(Type.BYTE_TYPE);\n");
                break;
            }
            case 52: {
                this.buf.append("mg.arrayLoad(Type.CHAR_TYPE);\n");
                break;
            }
            case 53: {
                this.buf.append("mg.arrayLoad(Type.SHORT_TYPE);\n");
                break;
            }
            case 79: {
                this.buf.append("mg.arrayStore(Type.INT_TYPE);\n");
                break;
            }
            case 80: {
                this.buf.append("mg.arrayStore(Type.LONG_TYPE);\n");
                break;
            }
            case 81: {
                this.buf.append("mg.arrayStore(Type.FLOAT_TYPE);\n");
                break;
            }
            case 82: {
                this.buf.append("mg.arrayStore(Type.DOUBLE_TYPE);\n");
                break;
            }
            case 83: {
                this.buf.append("mg.arrayStore(" + GASMifier.getType("java/lang/Object") + ");\n");
                break;
            }
            case 84: {
                this.buf.append("mg.arrayStore(Type.BYTE_TYPE);\n");
                break;
            }
            case 85: {
                this.buf.append("mg.arrayStore(Type.CHAR_TYPE);\n");
                break;
            }
            case 86: {
                this.buf.append("mg.arrayStore(Type.SHORT_TYPE);\n");
                break;
            }
            case 96: {
                this.buf.append("mg.math(GeneratorAdapter.ADD, Type.INT_TYPE);\n");
                break;
            }
            case 97: {
                this.buf.append("mg.math(GeneratorAdapter.ADD, Type.LONG_TYPE);\n");
                break;
            }
            case 98: {
                this.buf.append("mg.math(GeneratorAdapter.ADD, Type.FLOAT_TYPE);\n");
                break;
            }
            case 99: {
                this.buf.append("mg.math(GeneratorAdapter.ADD, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 100: {
                this.buf.append("mg.math(GeneratorAdapter.SUB, Type.INT_TYPE);\n");
                break;
            }
            case 101: {
                this.buf.append("mg.math(GeneratorAdapter.SUB, Type.LONG_TYPE);\n");
                break;
            }
            case 102: {
                this.buf.append("mg.math(GeneratorAdapter.SUB, Type.FLOAT_TYPE);\n");
                break;
            }
            case 103: {
                this.buf.append("mg.math(GeneratorAdapter.SUB, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 104: {
                this.buf.append("mg.math(GeneratorAdapter.MUL, Type.INT_TYPE);\n");
                break;
            }
            case 105: {
                this.buf.append("mg.math(GeneratorAdapter.MUL, Type.LONG_TYPE);\n");
                break;
            }
            case 106: {
                this.buf.append("mg.math(GeneratorAdapter.MUL, Type.FLOAT_TYPE);\n");
                break;
            }
            case 107: {
                this.buf.append("mg.math(GeneratorAdapter.MUL, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 108: {
                this.buf.append("mg.math(GeneratorAdapter.DIV, Type.INT_TYPE);\n");
                break;
            }
            case 109: {
                this.buf.append("mg.math(GeneratorAdapter.DIV, Type.LONG_TYPE);\n");
                break;
            }
            case 110: {
                this.buf.append("mg.math(GeneratorAdapter.DIV, Type.FLOAT_TYPE);\n");
                break;
            }
            case 111: {
                this.buf.append("mg.math(GeneratorAdapter.DIV, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 112: {
                this.buf.append("mg.math(GeneratorAdapter.REM, Type.INT_TYPE);\n");
                break;
            }
            case 113: {
                this.buf.append("mg.math(GeneratorAdapter.REM, Type.LONG_TYPE);\n");
                break;
            }
            case 114: {
                this.buf.append("mg.math(GeneratorAdapter.REM, Type.FLOAT_TYPE);\n");
                break;
            }
            case 115: {
                this.buf.append("mg.math(GeneratorAdapter.REM, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 116: {
                this.buf.append("mg.math(GeneratorAdapter.NEG, Type.INT_TYPE);\n");
                break;
            }
            case 117: {
                this.buf.append("mg.math(GeneratorAdapter.NEG, Type.LONG_TYPE);\n");
                break;
            }
            case 118: {
                this.buf.append("mg.math(GeneratorAdapter.NEG, Type.FLOAT_TYPE);\n");
                break;
            }
            case 119: {
                this.buf.append("mg.math(GeneratorAdapter.NEG, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 120: {
                this.buf.append("mg.math(GeneratorAdapter.SHL, Type.INT_TYPE);\n");
                break;
            }
            case 121: {
                this.buf.append("mg.math(GeneratorAdapter.SHL, Type.LONG_TYPE);\n");
                break;
            }
            case 122: {
                this.buf.append("mg.math(GeneratorAdapter.SHR, Type.INT_TYPE);\n");
                break;
            }
            case 123: {
                this.buf.append("mg.math(GeneratorAdapter.SHR, Type.LONG_TYPE);\n");
                break;
            }
            case 124: {
                this.buf.append("mg.math(GeneratorAdapter.USHR, Type.INT_TYPE);\n");
                break;
            }
            case 125: {
                this.buf.append("mg.math(GeneratorAdapter.USHR, Type.LONG_TYPE);\n");
                break;
            }
            case 126: {
                this.buf.append("mg.math(GeneratorAdapter.AND, Type.INT_TYPE);\n");
                break;
            }
            case 127: {
                this.buf.append("mg.math(GeneratorAdapter.AND, Type.LONG_TYPE);\n");
                break;
            }
            case 128: {
                this.buf.append("mg.math(GeneratorAdapter.OR, Type.INT_TYPE);\n");
                break;
            }
            case 129: {
                this.buf.append("mg.math(GeneratorAdapter.OR, Type.LONG_TYPE);\n");
                break;
            }
            case 130: {
                this.buf.append("mg.math(GeneratorAdapter.XOR, Type.INT_TYPE);\n");
                break;
            }
            case 131: {
                this.buf.append("mg.math(GeneratorAdapter.XOR, Type.LONG_TYPE);\n");
                break;
            }
            case 191: {
                this.buf.append("mg.throwException();\n");
                break;
            }
            case 133: {
                this.buf.append("mg.cast(Type.INT_TYPE, Type.LONG_TYPE);\n");
                break;
            }
            case 134: {
                this.buf.append("mg.cast(Type.INT_TYPE, Type.FLOAT_TYPE);\n");
                break;
            }
            case 135: {
                this.buf.append("mg.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 136: {
                this.buf.append("mg.cast(Type.LONG_TYPE, Type.INT_TYPE);\n");
                break;
            }
            case 137: {
                this.buf.append("mg.cast(Type.LONG_TYPE, Type.FLOAT_TYPE);\n");
                break;
            }
            case 138: {
                this.buf.append("mg.cast(Type.LONG_TYPE, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 139: {
                this.buf.append("mg.cast(Type.FLOAT_TYPE, Type.INT_TYPE);\n");
                break;
            }
            case 140: {
                this.buf.append("mg.cast(Type.FLOAT_TYPE, Type.LONG_TYPE);\n");
                break;
            }
            case 141: {
                this.buf.append("mg.cast(Type.FLOAT_TYPE, Type.DOUBLE_TYPE);\n");
                break;
            }
            case 142: {
                this.buf.append("mg.cast(Type.DOUBLE_TYPE, Type.INT_TYPE);\n");
                break;
            }
            case 143: {
                this.buf.append("mg.cast(Type.DOUBLE_TYPE, Type.LONG_TYPE);\n");
                break;
            }
            case 144: {
                this.buf.append("mg.cast(Type.DOUBLE_TYPE, Type.FLOAT_TYPE);\n");
                break;
            }
            case 145: {
                this.buf.append("mg.cast(Type.INT_TYPE, Type.BYTE_TYPE);\n");
                break;
            }
            case 146: {
                this.buf.append("mg.cast(Type.INT_TYPE, Type.CHAR_TYPE);\n");
                break;
            }
            case 147: {
                this.buf.append("mg.cast(Type.INT_TYPE, Type.SHORT_TYPE);\n");
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                this.buf.append("mg.visitInsn(").append(OPCODES[opcode]).append(");\n");
                break;
            }
            default: {
                throw new RuntimeException("unexpected case");
            }
        }
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int opcode, int operand) {
        this.buf.setLength(0);
        if (opcode == 188) {
            String type;
            switch (operand) {
                case 4: {
                    type = "Type.BOOLEAN_TYPE";
                    break;
                }
                case 5: {
                    type = "Type.CHAR_TYPE";
                    break;
                }
                case 6: {
                    type = "Type.FLOAT_TYPE";
                    break;
                }
                case 7: {
                    type = "Type.DOUBLE_TYPE";
                    break;
                }
                case 8: {
                    type = "Type.BYTE_TYPE";
                    break;
                }
                case 9: {
                    type = "Type.SHORT_TYPE";
                    break;
                }
                case 10: {
                    type = "Type.INT_TYPE";
                    break;
                }
                case 11: {
                    type = "Type.LONG_TYPE";
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected case");
                }
            }
            this.buf.append("mg.newArray(").append(type).append(");\n");
        } else {
            this.buf.append("mg.push(").append(operand).append(");\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int opcode, int var) {
        this.buf.setLength(0);
        try {
            switch (opcode) {
                case 169: {
                    if (var < this.firstLocal) {
                        this.buf.append("mg.ret(");
                        this.buf.append(var);
                        this.buf.append(");\n");
                    } else {
                        int v = this.generateNewLocal(var, "Type.INT_TYPE");
                        this.buf.append("mg.ret(");
                        this.buf.append("local").append(v);
                        this.buf.append(");\n");
                    }
                    break;
                }
                case 21: {
                    this.generateLoadLocal(var, "Type.INT_TYPE");
                    break;
                }
                case 22: {
                    this.generateLoadLocal(var, "Type.LONG_TYPE");
                    break;
                }
                case 23: {
                    this.generateLoadLocal(var, "Type.FLOAT_TYPE");
                    break;
                }
                case 24: {
                    this.generateLoadLocal(var, "Type.DOUBLE_TYPE");
                    break;
                }
                case 25: {
                    this.generateLoadLocal(var, GASMifier.getType("java/lang/Object"));
                    break;
                }
                case 54: {
                    this.generateStoreLocal(var, "Type.INT_TYPE");
                    break;
                }
                case 55: {
                    this.generateStoreLocal(var, "Type.LONG_TYPE");
                    break;
                }
                case 56: {
                    this.generateStoreLocal(var, "Type.FLOAT_TYPE");
                    break;
                }
                case 57: {
                    this.generateStoreLocal(var, "Type.DOUBLE_TYPE");
                    break;
                }
                case 58: {
                    this.generateStoreLocal(var, GASMifier.getType("java/lang/Object"));
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected case");
                }
            }
        }
        catch (RuntimeException e) {
            this.buf.append("mg.visitVarInsn(" + OPCODES[opcode] + ", " + var + ");\n");
        }
        this.text.add(this.buf.toString());
    }

    private void generateLoadLocal(int var, String type) {
        if (var < this.firstLocal) {
            if (var == 0 && (this.access & 8) == 0) {
                this.buf.append("mg.loadThis();\n");
            } else {
                int index = this.getArgIndex(var);
                this.buf.append("mg.loadArg(").append(index).append(");\n");
            }
        } else {
            int local = this.generateNewLocal(var, type);
            this.buf.append("mg.loadLocal(local").append(local);
            if (!type.equals(this.localTypes.get(local))) {
                this.localTypes.set(local, type);
                this.buf.append(", ").append(type);
            }
            this.buf.append(");\n");
        }
    }

    private void generateStoreLocal(int var, String type) {
        if (var < this.firstLocal) {
            if (var == 0 && (this.access & 8) == 0) {
                this.buf.append("mg.visitVarInsn(ASTORE, " + var + ");\n");
            } else {
                int index = this.getArgIndex(var);
                this.buf.append("mg.storeArg(").append(index).append(");\n");
            }
        } else {
            int local = this.generateNewLocal(var, type);
            this.buf.append("mg.storeLocal(local").append(local);
            if (!type.equals(this.localTypes.get(local))) {
                this.localTypes.set(local, type);
                this.buf.append(", ").append(type);
            }
            this.buf.append(");\n");
        }
    }

    private int generateNewLocal(int var, String type) {
        Integer i = this.locals.get(new Integer(var));
        if (i == null) {
            int local = this.locals.size();
            this.locals.put(new Integer(var), new Integer(local));
            this.localTypes.add(type);
            this.buf.append("int local" + local + " = mg.newLocal(" + type + ");\n");
            return local;
        }
        return i;
    }

    private int getArgIndex(int var) {
        int nextLocal = (8 & this.access) != 0 ? 0 : 1;
        int i = 0;
        while (nextLocal != var) {
            nextLocal += this.argumentTypes[i++].getSize();
        }
        return i;
    }

    public void visitTypeInsn(int opcode, String type) {
        String typ = GASMifier.getType(type);
        this.buf.setLength(0);
        if (opcode == 187) {
            this.buf.append("mg.newInstance(").append(typ).append(");\n");
        } else if (opcode == 189) {
            this.buf.append("mg.newArray(").append(typ).append(");\n");
        } else if (opcode == 192) {
            this.buf.append("mg.checkCast(").append(typ).append(");\n");
        } else if (opcode == 193) {
            this.buf.append("mg.instanceOf(").append(typ).append(");\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        switch (opcode) {
            case 180: {
                this.buf.append("mg.getField(");
                break;
            }
            case 181: {
                this.buf.append("mg.putField(");
                break;
            }
            case 178: {
                this.buf.append("mg.getStatic(");
                break;
            }
            case 179: {
                this.buf.append("mg.putStatic(");
                break;
            }
            default: {
                throw new RuntimeException("unexpected case");
            }
        }
        this.buf.append(GASMifier.getType(owner));
        this.buf.append(", \"");
        this.buf.append(name);
        this.buf.append("\", ");
        this.buf.append(GASMifier.getDescType(desc));
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.buf.setLength(0);
        switch (opcode) {
            case 182: {
                this.buf.append("mg.invokeVirtual(");
                break;
            }
            case 183: {
                this.buf.append("mg.invokeConstructor(");
                break;
            }
            case 184: {
                this.buf.append("mg.invokeStatic(");
                break;
            }
            case 185: {
                this.buf.append("mg.invokeInterface(");
                break;
            }
            default: {
                throw new RuntimeException("unexpected case");
            }
        }
        if (owner.charAt(0) == '[') {
            this.buf.append(GASMifier.getDescType(owner));
        } else {
            this.buf.append(GASMifier.getType(owner));
        }
        this.buf.append(", ");
        this.buf.append(GASMifier.getMethod(name, desc));
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.buf.setLength(0);
        this.buf.append("mg.invokeDynamic(");
        this.appendConstant(name);
        this.buf.append(", ");
        this.appendConstant(desc);
        this.buf.append(", ");
        this.appendConstant(bsm);
        this.buf.append(", new Object[] {");
        int i = 0;
        while (i < bsmArgs.length) {
            this.appendConstant(bsmArgs[i]);
            if (i != bsmArgs.length - 1) {
                this.buf.append(", ");
            }
            ++i;
        }
        this.buf.append("});\n");
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        if (opcode == 167 || opcode == 198 || opcode == 199) {
            if (opcode == 167) {
                this.buf.append("mg.goTo(");
            }
            if (opcode == 198) {
                this.buf.append("mg.ifNull(");
            }
            if (opcode == 199) {
                this.buf.append("mg.ifNonNull(");
            }
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 159) {
            this.buf.append("mg.ifICmp(GeneratorAdapter.EQ, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 160) {
            this.buf.append("mg.ifICmp(GeneratorAdapter.NE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 161) {
            this.buf.append("mg.ifICmp(GeneratorAdapter.LT, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 162) {
            this.buf.append("mg.ifICmp(GeneratorAdapter.GE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 163) {
            this.buf.append("mg.ifICmp(GeneratorAdapter.GT, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 164) {
            this.buf.append("mg.ifICmp(GeneratorAdapter.LE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 165) {
            this.buf.append("mg.ifCmp(");
            this.buf.append(GASMifier.getType("java/lang/Object")).append(", ").append("GeneratorAdapter.EQ, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 166) {
            this.buf.append("mg.ifCmp(");
            this.buf.append(GASMifier.getType("java/lang/Object")).append(", ").append("GeneratorAdapter.NE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 153) {
            this.buf.append("mg.ifZCmp(GeneratorAdapter.EQ, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 154) {
            this.buf.append("mg.ifZCmp(GeneratorAdapter.NE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 155) {
            this.buf.append("mg.ifZCmp(GeneratorAdapter.LT, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 156) {
            this.buf.append("mg.ifZCmp(GeneratorAdapter.GE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 157) {
            this.buf.append("mg.ifZCmp(GeneratorAdapter.GT, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else if (opcode == 158) {
            this.buf.append("mg.ifZCmp(GeneratorAdapter.LE, ");
            this.appendLabel(label);
            this.buf.append(");\n");
        } else {
            this.buf.append("mg.visitJumpInsn(").append(OPCODES[opcode]).append(", ");
            this.appendLabel(label);
            this.buf.append(");\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mg.mark(");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object cst) {
        this.buf.setLength(0);
        this.buf.append("mg.push(");
        this.appendConstant(cst);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int var, int increment) {
        this.buf.setLength(0);
        if (var < this.firstLocal) {
            this.buf.append("mg.iinc(").append(var);
        } else {
            int v = this.generateNewLocal(var, "Type.INT_TYPE");
            this.buf.append("mg.iinc(local").append(v);
        }
        this.buf.append(", ").append(increment).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        String idx = index < this.firstLocal ? new Integer(index).toString() : "local" + this.locals.get(new Integer(index));
        this.buf.setLength(0);
        this.buf.append(this.name).append(".getNext().visitLocalVariable(");
        this.appendConstant(name);
        this.buf.append(", ");
        this.appendConstant(desc);
        this.buf.append(", ");
        this.appendConstant(signature);
        this.buf.append(", ");
        this.appendLabel(start);
        this.buf.append(", ");
        this.appendLabel(end);
        this.buf.append(", ").append(idx).append(");\n");
        this.text.add(this.buf.toString());
    }

    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = ").append(this.name).append(".getNext().visitLocalVariableAnnotation(");
        this.buf.append(typeRef);
        this.buf.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        this.buf.append("new Label[] {");
        int i = 0;
        while (i < start.length) {
            this.buf.append(i == 0 ? " " : ", ");
            this.appendLabel(start[i]);
            ++i;
        }
        this.buf.append(" }, new Label[] {");
        i = 0;
        while (i < end.length) {
            this.buf.append(i == 0 ? " " : ", ");
            this.appendLabel(end[i]);
            ++i;
        }
        this.buf.append(" }, new int[] {");
        i = 0;
        while (i < index.length) {
            String idx = index[i] < this.firstLocal ? new Integer(index[i]).toString() : "local" + this.locals.get(new Integer(index[i]));
            this.buf.append(i == 0 ? " " : ", ").append(idx);
            ++i;
        }
        this.buf.append(" }, ");
        this.appendConstant(desc);
        this.buf.append(", ").append(visible).append(");\n");
        this.text.add(this.buf.toString());
        ASMifier a = this.createASMifier("av", 0);
        this.text.add(a.getText());
        this.text.add("}\n");
        return a;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.text.add("mg.endMethod();\n");
    }

    protected ASMifier createASMifier(String name, int id) {
        return new GASMifier(name, id);
    }

    static String getType(String internalName) {
        return "Type.getObjectType(\"" + internalName + "\")";
    }

    static String getDescType(String desc) {
        if (desc.equals("Z")) {
            return "Type.BOOLEAN_TYPE";
        }
        if (desc.equals("B")) {
            return "Type.BYTE_TYPE";
        }
        if (desc.equals("C")) {
            return "Type.CHAR_TYPE";
        }
        if (desc.equals("D")) {
            return "Type.DOUBLE_TYPE";
        }
        if (desc.equals("F")) {
            return "Type.FLOAT_TYPE";
        }
        if (desc.equals("I")) {
            return "Type.INT_TYPE";
        }
        if (desc.equals("J")) {
            return "Type.LONG_TYPE";
        }
        if (desc.equals("S")) {
            return "Type.SHORT_TYPE";
        }
        if (desc.equals("V")) {
            return "Type.VOID_TYPE";
        }
        return "Type.getType(\"" + desc + "\")";
    }

    static String getMethod(String name, String desc) {
        Type rt = Type.getReturnType(desc);
        Type[] argt = Type.getArgumentTypes(desc);
        StringBuilder buf = new StringBuilder();
        buf.append("Method.getMethod(\"");
        buf.append(rt.getClassName()).append(' ');
        buf.append(name).append('(');
        int i = 0;
        while (i < argt.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(argt[i].getClassName());
            ++i;
        }
        buf.append(")\")");
        return buf.toString();
    }

    protected void declareLabel(Label l) {
        String name;
        if (this.labelNames == null) {
            this.labelNames = new HashMap();
        }
        if ((name = (String)this.labelNames.get(l)) == null) {
            name = "label" + this.labelNames.size();
            this.labelNames.put(l, name);
            this.buf.append("Label ").append(name).append(" = mg.newLabel();\n");
        }
    }
}

