/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.CodeSizeEvaluator;

public class CodeSizeEvaluatorTest
extends AbstractTest {
    public static TestSuite suite() throws Exception {
        return new CodeSizeEvaluatorTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        cr.accept(new ClassVisitor(327680, new ClassWriter(0)){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
                return new CodeSizeEvaluator(mv){

                    public void visitMaxs(int maxStack, int maxLocals) {
                        Label end = new Label();
                        this.mv.visitLabel(end);
                        this.mv.visitMaxs(maxStack, maxLocals);
                        int size = end.getOffset();
                        CodeSizeEvaluatorTest.assertTrue((String)(String.valueOf(this.getMinSize()) + " <= " + size + " <= " + this.getMaxSize()), (this.getMinSize() <= size && size <= this.getMaxSize() ? 1 : 0) != 0);
                    }
                };
            }
        }, 0);
    }
}

