/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ClassRemapperUnitTest
extends TestCase
implements Opcodes {
    public void testClassRemapper() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Boo", "B1");
        map.put("Coo", "C1");
        map.put("Doo", "D1");
        SimpleRemapper remapper = new SimpleRemapper(map);
        ClassNode cn = new ClassNode();
        ClassRemapperUnitTest.dump(new ClassRemapper(cn, remapper));
        ClassRemapperUnitTest.assertEquals((String)"D1", (String)cn.name);
        ClassRemapperUnitTest.assertEquals((String)"B1", (String)cn.superName);
        ClassRemapperUnitTest.assertEquals(Arrays.asList("I", "I", "C1", "J", "B1"), cn.interfaces);
        ClassRemapperUnitTest.assertEquals((String)"LB1;", (String)this.field((ClassNode)cn, (int)0).desc);
        ClassRemapperUnitTest.assertEquals((String)"[LB1;", (String)this.field((ClassNode)cn, (int)1).desc);
        ClassRemapperUnitTest.assertEquals((String)"D1", (String)this.innerClass((ClassNode)cn, (int)0).name);
        ClassRemapperUnitTest.assertEquals((String)"B1", (String)this.innerClass((ClassNode)cn, (int)0).outerName);
        ClassRemapperUnitTest.assertEquals((String)"B1", (String)cn.outerClass);
        ClassRemapperUnitTest.assertEquals((String)"([[LB1;LC1;LD1;)LC1;", (String)cn.outerMethodDesc);
        MethodNode mn0 = cn.methods.get(0);
        ListIterator<AbstractInsnNode> it = mn0.instructions.iterator();
        FieldInsnNode n0 = (FieldInsnNode)it.next();
        ClassRemapperUnitTest.assertEquals((String)"D1", (String)n0.owner);
        ClassRemapperUnitTest.assertEquals((String)"LB1;", (String)n0.desc);
        ClassRemapperUnitTest.assertEquals((Object)Type.getType("LB1;"), (Object)((LdcInsnNode)it.next()).cst);
        ClassRemapperUnitTest.assertEquals((Object)Type.getType("[LD1;"), (Object)((LdcInsnNode)it.next()).cst);
        ClassRemapperUnitTest.assertEquals((Object)Type.getType("[I"), (Object)((LdcInsnNode)it.next()).cst);
        ClassRemapperUnitTest.assertEquals((Object)Type.getType("J"), (Object)((LdcInsnNode)it.next()).cst);
        ClassRemapperUnitTest.assertEquals((String)"B1", (String)((TypeInsnNode)it.next()).desc);
        ClassRemapperUnitTest.assertEquals((String)"[LD1;", (String)((TypeInsnNode)it.next()).desc);
        ClassRemapperUnitTest.assertEquals((String)"[I", (String)((TypeInsnNode)it.next()).desc);
        ClassRemapperUnitTest.assertEquals((String)"J", (String)((TypeInsnNode)it.next()).desc);
        MultiANewArrayInsnNode n3 = (MultiANewArrayInsnNode)it.next();
        ClassRemapperUnitTest.assertEquals((String)"[[LB1;", (String)n3.desc);
        MethodInsnNode n4 = (MethodInsnNode)it.next();
        ClassRemapperUnitTest.assertEquals((String)"D1", (String)n4.owner);
        ClassRemapperUnitTest.assertEquals((String)"([[LB1;LC1;LD1;)LC1;", (String)n4.desc);
        FrameNode fn0 = (FrameNode)it.next();
        ClassRemapperUnitTest.assertEquals((Object)Collections.EMPTY_LIST, fn0.local);
        ClassRemapperUnitTest.assertEquals((Object)Collections.EMPTY_LIST, fn0.stack);
        ClassRemapperUnitTest.assertEquals(Arrays.asList("B1", "C1", "D1"), ((FrameNode)it.next()).local);
        ClassRemapperUnitTest.assertEquals(Arrays.asList(Opcodes.INTEGER, "C1", Opcodes.INTEGER, "D1"), ((FrameNode)it.next()).local);
        ClassRemapperUnitTest.assertEquals(Arrays.asList(Opcodes.INTEGER, Opcodes.INTEGER), ((FrameNode)it.next()).local);
        TryCatchBlockNode tryCatchBlockNode = mn0.tryCatchBlocks.get(0);
        ClassRemapperUnitTest.assertEquals((String)"C1", (String)tryCatchBlockNode.type);
        MethodNode mn1 = cn.methods.get(1);
        ClassRemapperUnitTest.assertEquals((String)"([[LB1;LC1;LD1;)V", (String)mn1.desc);
        ClassRemapperUnitTest.assertEquals(Arrays.asList("I", "J"), mn1.exceptions);
    }

    private FieldNode field(ClassNode cn, int n) {
        return cn.fields.get(n);
    }

    private InnerClassNode innerClass(ClassNode cn, int n) {
        return cn.innerClasses.get(n);
    }

    public static void dump(ClassVisitor cv) throws Exception {
        cv.visit(49, 0, "Doo", null, "Boo", new String[]{"I", "I", "Coo", "J", "Boo"});
        cv.visitInnerClass("Doo", "Boo", "Doo", 0);
        cv.visitOuterClass("Boo", "foo", "([[LBoo;LCoo;LDoo;)LCoo;");
        cv.visitField(0, "boo", "LBoo;", null, null).visitEnd();
        cv.visitField(0, "boo1", "[LBoo;", null, null).visitEnd();
        cv.visitField(0, "s", "Ljava/lang/String;", null, null).visitEnd();
        cv.visitField(0, "i", "I", null, null).visitEnd();
        MethodVisitor mv = cv.visitMethod(0, "foo", "()V", null, null);
        mv.visitCode();
        mv.visitFieldInsn(180, "Doo", "boo", "LBoo;");
        mv.visitLdcInsn(Type.getType("LBoo;"));
        mv.visitLdcInsn(Type.getType("[LDoo;"));
        mv.visitLdcInsn(Type.getType("[I"));
        mv.visitLdcInsn(Type.getType("J"));
        mv.visitTypeInsn(189, "Boo");
        mv.visitTypeInsn(189, "[LDoo;");
        mv.visitTypeInsn(189, "[I");
        mv.visitTypeInsn(189, "J");
        mv.visitMultiANewArrayInsn("[[LBoo;", 2);
        mv.visitMethodInsn(182, "Doo", "goo", "([[LBoo;LCoo;LDoo;)LCoo;", false);
        mv.visitFrame(-1, 0, new Object[5], 0, new Object[10]);
        mv.visitFrame(-1, 3, new Object[]{"Boo", "Coo", "Doo"}, 0, new Object[0]);
        mv.visitFrame(-1, 4, new Object[]{Opcodes.INTEGER, "Coo", Opcodes.INTEGER, "Doo"}, 0, new Object[0]);
        mv.visitFrame(-1, 2, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER}, 0, new Object[0]);
        Label l = new Label();
        mv.visitLocalVariable("boo", "LBoo;", null, l, l, 1);
        mv.visitLocalVariable("boo1", "[LBoo;", null, l, l, 3);
        mv.visitLocalVariable("boo2", "[[LBoo;", null, l, l, 4);
        mv.visitMaxs(0, 0);
        mv.visitTryCatchBlock(l, l, l, "Coo");
        mv.visitEnd();
        mv = cv.visitMethod(0, "goo", "([[LBoo;LCoo;LDoo;)V", null, new String[]{"I", "J"});
        mv.visitEnd();
        cv.visitEnd();
    }

    public static class Boo {
    }

    public static interface Coo {
    }

    public static class Doo
    extends Boo
    implements Coo {
        Boo boo = new Boo();
        Boo[] boo1 = new Boo[2];
        String s = "";
        int i = 5;
        static final Class<?> c1 = Boo.class;
        static final Class<?> c2 = Boo[].class;

        public Doo() {
        }

        public Doo(int i, Coo coo, Boo boo) {
        }

        void foo() {
            class Eoo {
                String s;

                Eoo() {
                }
            }
            Eoo e = new Eoo();
            e.s = "aaa";
            Boo boo = this.boo;
            Class<Boo> cc = Boo.class;
            Boo[] boo1 = new Boo[2];
            Boo[][] boo2 = new Boo[2][2];
            this.goo(boo2, this, this);
        }

        Coo goo(Boo[][] boo2, Coo coo, Doo doo) {
            return null;
        }
    }
}

