/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ComputeClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.attrs.CodeComment;

public class ClassWriterResizeInsnsTest
extends AbstractTest {
    public static void premain(final String agentArgs, Instrumentation inst) {
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] b) throws IllegalClassFormatException {
                String n = className.replace('/', '.');
                if (agentArgs.length() == 0 || n.indexOf(agentArgs) != -1) {
                    try {
                        b = ClassWriterResizeInsnsTest.transformClass(b, 2);
                        if (n.equals("pkg.FrameMap")) {
                            ClassWriterResizeInsnsTest.transformClass(b, 0);
                        }
                        return b;
                    }
                    catch (Throwable e) {
                        return ClassWriterResizeInsnsTest.transformClass(b, 0);
                    }
                }
                return null;
            }
        });
    }

    static byte[] transformClass(byte[] clazz, final int flags) {
        ClassReader cr = new ClassReader(clazz);
        ComputeClassWriter cw = new ComputeClassWriter(flags);
        ClassVisitor ca = new ClassVisitor(327680, cw){
            boolean transformed;
            {
                super($anonymous0, $anonymous1);
                this.transformed = false;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (flags == 2) {
                    version = (version & 0xFFFF) < 51 ? 51 : version;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680, this.cv.visitMethod(access, name, desc, signature, exceptions)){
                    private final HashSet<Label> labels;
                    {
                        this.labels = new HashSet();
                    }

                    public void visitLabel(Label label) {
                        super.visitLabel(label);
                        this.labels.add(label);
                    }

                    public void visitJumpInsn(int opcode, Label label) {
                        super.visitJumpInsn(opcode, label);
                        if (opcode != 167 && !transformed && !this.labels.contains(label)) {
                            transformed = true;
                            int i = 0;
                            while (i < 33000) {
                                this.mv.visitInsn(0);
                                ++i;
                            }
                        }
                    }
                };
            }
        };
        cr.accept(ca, new Attribute[]{new CodeComment()}, 0);
        return cw.toByteArray();
    }

    public static TestSuite suite() throws Exception {
        TestSuite suite = new ClassWriterResizeInsnsTest().getSuite();
        suite.addTest((Test)new AbstractTest.VerifierTest());
        return suite;
    }

    public void test() throws Exception {
        try {
            Class.forName(this.n, true, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (ClassFormatError cfe) {
            ClassWriterResizeInsnsTest.fail((String)cfe.getMessage());
        }
        catch (VerifyError ve) {
            ClassWriterResizeInsnsTest.fail((String)ve.toString());
        }
    }
}

