/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import junit.framework.TestCase;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassWriterComputeFramesUnitTest
extends TestCase {
    private byte[] getClassBytes() throws IOException {
        String className = ClassWriterComputeFramesUnitTest.class.getName();
        ClassWriter cw = new ClassWriter(2);
        new ClassReader(className).accept(new ClassVisitor(327680, cw){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit((version & 0xFFFF) < 51 ? 51 : version, access, name, signature, superName, interfaces);
            }
        }, 4);
        return cw.toByteArray();
    }

    public void testSameDimension0() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "sameDimension0");
    }

    public static Number sameDimension0(boolean b) {
        return Float.valueOf(b ? (float)new Integer(1).intValue() : new Float(1.0f).floatValue());
    }

    public void testSameDimension1() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "sameDimension1");
    }

    public static Number[] sameDimension1(boolean b) {
        return b ? new Integer[1] : new Float[1];
    }

    public void testSameDimension2() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "sameDimension2");
    }

    public static Number[][] sameDimension2(boolean b) {
        return b ? new Integer[1][1] : new Float[1][1];
    }

    public void testSameDimension3() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "sameDimension3");
    }

    public static Object[] sameDimension3(boolean b) {
        return b ? new byte[1][1] : (byte[][])new short[1][1];
    }

    public void testSameDimension4() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "sameDimension4");
    }

    public static Object sameDimension4(boolean b) {
        return b ? new byte[1] : (byte[])new Float[1];
    }

    public void testSameDimension5() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "sameDimension5");
    }

    public static Object[] sameDimension5(boolean b) {
        return b ? new byte[1][1] : (byte[][])new Float[1][1];
    }

    public void testDifferentDimension1() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "differentDimension1");
    }

    public static Object differentDimension1(boolean b) {
        return b ? new byte[1] : (byte[])new byte[1][1];
    }

    public void testDifferentDimension2() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "differentDimension2");
    }

    public static Object[] differentDimension2(boolean b) {
        return b ? new Object[1] : (Object[])new byte[1][1];
    }

    public void testDifferentDimension3() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "differentDimension3");
    }

    public static Object[] differentDimension3(boolean b) {
        return b ? new byte[1][1] : (byte[][])new byte[1][1][1];
    }

    public void testDifferentDimension4() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "differentDimension4");
    }

    public static Object[][] differentDimension4(boolean b) {
        return b ? new byte[1][1][1] : (byte[][][])new byte[1][1][1][1];
    }

    public void testDifferentDimension5() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "differentDimension5");
    }

    public static Object differentDimension5(boolean b) {
        return b ? new Integer(1) : (Object)new byte[1];
    }

    public void testDifferentDimension6() throws Exception {
        new TestClassLoader().test(this.getClassBytes(), "differentDimension6");
    }

    public static Object differentDimension6(boolean b) {
        return b ? new Integer(1) : new Float[1];
    }

    static class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public void test(byte[] b, String methodName) throws Exception {
            String className = ClassWriterComputeFramesUnitTest.class.getName();
            this.defineClass(className, b, 0, b.length).getDeclaredMethod(methodName, Boolean.TYPE);
        }
    }
}

