/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ComputeClassWriter;
import org.objectweb.asm.MethodDeadCodeInserter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassWriterComputeFramesDeadCodeTest
extends AbstractTest {
    public static void premain(final String agentArgs, Instrumentation inst) {
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classFileBuffer) throws IllegalClassFormatException {
                String n = className.replace('/', '.');
                if (n.indexOf("javax") == -1 || n.startsWith("invalid.")) {
                    return null;
                }
                if (agentArgs.length() == 0 || n.indexOf(agentArgs) != -1) {
                    return ClassWriterComputeFramesDeadCodeTest.transformClass(n, classFileBuffer);
                }
                return null;
            }
        });
    }

    static byte[] transformClass(String n, byte[] clazz) {
        ClassReader cr = new ClassReader(clazz);
        ComputeClassWriter cw = new ComputeClassWriter(2);
        cr.accept(new ClassVisitor(327680, cw){
            private String className;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                super.visit((version & 0xFFFF) < 51 ? 51 : version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                int seed = (String.valueOf(this.className) + "." + name + desc).hashCode();
                return new MethodDeadCodeInserter(seed, super.visitMethod(access, name, desc, signature, exceptions));
            }
        }, 6);
        byte[] b = cw.toByteArray();
        if (n.equals("javax.imageio.ImageIO")) {
            new ClassReader(b).accept(new TraceClassVisitor(new PrintWriter(System.err)), 0);
        }
        return b;
    }

    public static TestSuite suite() throws Exception {
        TestSuite suite = new ClassWriterComputeFramesDeadCodeTest().getSuite();
        suite.addTest((Test)new AbstractTest.VerifierTest());
        return suite;
    }

    public void test() throws Exception {
        try {
            Class.forName(this.n, true, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (ClassFormatError cfe) {
            ClassWriterComputeFramesDeadCodeTest.fail((String)cfe.getMessage());
        }
        catch (VerifyError ve) {
            ClassWriterComputeFramesDeadCodeTest.fail((String)ve.getMessage());
        }
    }
}

