/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class ClassAdapterTest
extends AbstractTest {
    private static final TestClassLoader LOADER = new TestClassLoader();

    public static TestSuite suite() throws Exception {
        return new ClassAdapterTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        ClassWriter cw = new ClassWriter(1);
        cr.accept(new ClassVisitor(327680, cw){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return new AnnotationAdapter(super.visitAnnotation(desc, visible));
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                return new AnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return new FieldVisitor(327680, super.visitField(access, name, desc, signature, value)){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitAnnotation(desc, visible));
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
                    }
                };
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                    public AnnotationVisitor visitAnnotationDefault() {
                        return new AnnotationAdapter(super.visitAnnotationDefault());
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitAnnotation(desc, visible));
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitParameterAnnotation(parameter, desc, visible));
                    }

                    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitInsnAnnotation(typeRef, typePath, desc, visible));
                    }

                    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitTryCatchAnnotation(typeRef, typePath, desc, visible));
                    }

                    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
                        return new AnnotationAdapter(super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible));
                    }
                };
            }
        }, 0);
        byte[] b = cw.toByteArray();
        try {
            LOADER.defineClass(this.n, b);
        }
        catch (ClassFormatError cfe) {
            ClassAdapterTest.fail((String)cfe.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class AnnotationAdapter
    extends AnnotationVisitor {
        public AnnotationAdapter(AnnotationVisitor av) {
            super(327680, av);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationAdapter(super.visitAnnotation(name, desc));
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnotationAdapter(super.visitArray(name));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

