/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class AnnotationsTest
extends AbstractTest {
    public static TestSuite suite() throws Exception {
        return new AnnotationsTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        ClassWriter cw1 = new ClassWriter(0);
        ClassWriter cw2 = new ClassWriter(0);
        cr.accept(new RemoveAnnotationsAdapter1(cw1), 0);
        cr.accept(new RemoveAnnotationsAdapter2(cw2), 0);
        this.assertEquals(new ClassReader(cw2.toByteArray()), new ClassReader(cw1.toByteArray()));
    }

    static class EmptyAnnotationVisitor
    extends AnnotationVisitor {
        public EmptyAnnotationVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    static class RemoveAnnotationsAdapter1
    extends ClassVisitor {
        public RemoveAnnotationsAdapter1(ClassVisitor cv) {
            super(327680, cv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new EmptyAnnotationVisitor();
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return new EmptyAnnotationVisitor();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680, this.cv.visitMethod(access, name, desc, signature, exceptions)){

                public AnnotationVisitor visitAnnotationDefault() {
                    return new EmptyAnnotationVisitor();
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new EmptyAnnotationVisitor();
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return new EmptyAnnotationVisitor();
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return new EmptyAnnotationVisitor();
                }

                public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return new EmptyAnnotationVisitor();
                }

                public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return new EmptyAnnotationVisitor();
                }

                public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
                    return new EmptyAnnotationVisitor();
                }
            };
        }
    }

    static class RemoveAnnotationsAdapter2
    extends ClassVisitor {
        public RemoveAnnotationsAdapter2(ClassVisitor cv) {
            super(327680, cv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680, this.cv.visitMethod(access, name, desc, signature, exceptions)){

                public AnnotationVisitor visitAnnotationDefault() {
                    return null;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return null;
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return null;
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return null;
                }

                public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return null;
                }

                public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return null;
                }

                public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
                    return null;
                }
            };
        }
    }
}

