/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class ClassPathRepository
implements Repository {
    private ClassPath _path = null;
    private final Map<String, JavaClass> _loadedClasses = new HashMap<String, JavaClass>();

    public ClassPathRepository(ClassPath path) {
        this._path = path;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        return this._loadedClasses.get(className);
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        InputStream clsStream = null;
        try {
            String className = clazz.getName();
            JavaClass repositoryClass = this.findClass(className);
            if (repositoryClass != null) {
                JavaClass javaClass = repositoryClass;
                return javaClass;
            }
            String name = className;
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(i + 1);
            }
            clsStream = clazz.getResourceAsStream(name + ".class");
            JavaClass javaClass = this.loadClass(clsStream, className);
            return javaClass;
        }
        finally {
            try {
                if (clsStream != null) {
                    clsStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private JavaClass loadClass(InputStream is, String className) throws ClassNotFoundException {
        try {
            if (is != null) {
                ClassParser parser = new ClassParser(is, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                JavaClass javaClass = clazz;
                return javaClass;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public ClassPath getClassPath() {
        return this._path;
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

