/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.StackMapTableEntry;
import org.apache.bcel.classfile.Visitor;

public final class StackMapTable
extends Attribute {
    private StackMapTableEntry[] map;

    public StackMapTable(int name_index, int length, StackMapTableEntry[] map, ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.map = map;
    }

    StackMapTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapTableEntry[])null, constant_pool);
        int map_length = input.readUnsignedShort();
        this.map = new StackMapTableEntry[map_length];
        for (int i = 0; i < map_length; ++i) {
            this.map[i] = new StackMapTableEntry(input, constant_pool);
        }
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.map.length);
        for (StackMapTableEntry entry : this.map) {
            entry.dump(file);
        }
    }

    public final StackMapTableEntry[] getStackMapTable() {
        return this.map;
    }

    public final void setStackMapTable(StackMapTableEntry[] map) {
        this.map = map;
        int len = 2;
        for (StackMapTableEntry element : map) {
            len += element.getMapEntrySize();
        }
        this.setLength(len);
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("StackMapTable(");
        for (int i = 0; i < this.map.length; ++i) {
            buf.append(this.map[i]);
            if (i >= this.map.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        StackMapTable c = (StackMapTable)this.clone();
        c.map = new StackMapTableEntry[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void accept(Visitor v) {
        throw new UnsupportedOperationException();
    }

    public final int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

