/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SortableStringComparator;
import edu.umd.cs.findbugs.gui2.Sortables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BugSet
implements Iterable<BugLeafNode> {
    private ArrayList<BugLeafNode> mainList;
    private final HashMap<BugAspects.SortableValue, BugSet> doneMap;
    private final HashMap<BugAspects.SortableValue, Boolean> doneContainsMap;
    private HashMap<Sortables, String[]> sortablesToStrings;
    private static BugSet mainBugSet = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    BugSet cache = null;

    public static BugSet getMainBugSet() {
        return mainBugSet;
    }

    public String[] getAll(Sortables s) {
        return this.getDistinctValues(s);
    }

    BugSet(Collection<? extends BugLeafNode> filteredSet) {
        this.mainList = new ArrayList<BugLeafNode>(filteredSet);
        this.doneMap = new HashMap();
        this.doneContainsMap = new HashMap();
        this.cacheSortables();
    }

    BugSet(BugCollection bugCollection) {
        this(Collections.emptyList());
        Iterator<BugInstance> i = bugCollection.iterator();
        while (i.hasNext()) {
            this.mainList.add(new BugLeafNode(i.next()));
        }
    }

    static void setAsRootAndCache(BugSet bs) {
        mainBugSet = bs;
        bs.sortList();
        bs.cacheSortables();
    }

    static boolean suppress(BugLeafNode p) {
        return !MainFrame.getInstance().shouldDisplayIssue(p.getBug());
    }

    void cacheSortables() {
        this.sortablesToStrings = new HashMap();
    }

    String[] getDistinctValues(Sortables key) {
        String[] list = this.sortablesToStrings.get(key);
        if (list == null) {
            list = this.computeDistinctValues(key);
            this.sortablesToStrings.put(key, list);
        }
        return list;
    }

    String[] computeDistinctValues(Sortables key) {
        if (key == Sortables.DIVIDER) {
            return EMPTY_STRING_ARRAY;
        }
        HashSet<String> list = new HashSet<String>();
        for (BugLeafNode p : this.mainList) {
            if (BugSet.suppress(p)) continue;
            BugInstance bug = p.getBug();
            String value = key.getFrom(bug);
            list.add(value);
        }
        String[] result = list.toArray(new String[list.size()]);
        Collections.sort(Arrays.asList(result), new SortableStringComparator(key));
        return result;
    }

    static int countFilteredBugs() {
        int result = 0;
        for (BugLeafNode bug : BugSet.getMainBugSet().mainList) {
            if (!BugSet.suppress(bug)) continue;
            ++result;
        }
        return result;
    }

    BugSet(BugSet copySet) {
        this.mainList = copySet.mainList;
        this.doneMap = new HashMap();
        this.doneContainsMap = new HashMap();
        this.cacheSortables();
    }

    BugSet query(BugAspects.SortableValue keyValuePair) {
        if (this.doneMap.containsKey(keyValuePair)) {
            return this.doneMap.get(keyValuePair);
        }
        ArrayList<BugLeafNode> bugs = new ArrayList<BugLeafNode>();
        for (BugLeafNode b : this.mainList) {
            if (!b.matches(keyValuePair)) continue;
            bugs.add(b);
        }
        BugSet temp = new BugSet(bugs);
        this.doneMap.put(keyValuePair, temp);
        return temp;
    }

    void sortList() {
        final List<Sortables> order = MainFrame.getInstance().getSorter().getOrderAfterDivider();
        Comparator<BugLeafNode> comparator = new Comparator<BugLeafNode>(){

            @Override
            int compare(int one, int two) {
                if (one > two) {
                    return 1;
                }
                if (one < two) {
                    return -1;
                }
                return 0;
            }

            @Override
            public int compare(BugLeafNode one, BugLeafNode two) {
                int result;
                if (one == two) {
                    return 0;
                }
                for (Sortables i : order) {
                    result = i.getBugLeafNodeComparator().compare(one, two);
                    if (result == 0) continue;
                    return result;
                }
                BugInstance bugOne = one.getBug();
                BugInstance bugTwo = two.getBug();
                result = bugOne.getPrimaryClass().getClassName().compareTo(bugTwo.getPrimaryClass().getClassName());
                if (result != 0) {
                    return result;
                }
                SourceLineAnnotation oneSource = bugOne.getPrimarySourceLineAnnotation();
                SourceLineAnnotation twoSource = bugTwo.getPrimarySourceLineAnnotation();
                result = oneSource.getClassName().compareTo(twoSource.getClassName());
                if (result != 0) {
                    return result;
                }
                result = this.compare(oneSource.getStartLine(), twoSource.getStartLine());
                if (result != 0) {
                    return result;
                }
                result = this.compare(oneSource.getEndLine(), twoSource.getEndLine());
                if (result != 0) {
                    return result;
                }
                result = this.compare(oneSource.getStartBytecode(), twoSource.getStartBytecode());
                if (result != 0) {
                    return result;
                }
                result = this.compare(oneSource.getEndBytecode(), twoSource.getEndBytecode());
                return result;
            }
        };
        ArrayList<BugLeafNode> copy = new ArrayList<BugLeafNode>(this.mainList);
        Collections.sort(copy, comparator);
        this.mainList = copy;
        if (SystemProperties.ASSERTIONS_ENABLED) {
            for (int i = 0; i < this.mainList.size(); ++i) {
                BugLeafNode nodeI = this.mainList.get(i);
                for (int j = i + 1; j < this.mainList.size(); ++j) {
                    BugLeafNode nodeJ = this.mainList.get(j);
                    if (comparator.compare(nodeI, nodeJ) > 0) {
                        throw new AssertionError((Object)String.format("bug list isn't consistently sorted (%d:%s) vs. (%d:%s)", i, nodeI.getBug().getInstanceHash(), j, nodeJ.getBug().getInstanceHash()));
                    }
                }
            }
        }
    }

    public boolean contains(BugAspects.SortableValue keyValuePair) {
        if (this.doneContainsMap.containsKey(keyValuePair)) {
            return this.doneContainsMap.get(keyValuePair);
        }
        for (BugLeafNode p : this.filteredBugsCached().mainList) {
            if (!p.matches(keyValuePair)) continue;
            this.doneContainsMap.put(keyValuePair, true);
            return true;
        }
        this.doneContainsMap.put(keyValuePair, false);
        return false;
    }

    public BugSet query(BugAspects a) {
        BugSet result = this;
        for (BugAspects.SortableValue sp : a) {
            result = result.query(sp);
        }
        return result;
    }

    public int sizeUnfiltered() {
        return this.mainList.size();
    }

    public int indexOfUnfiltered(BugLeafNode p) {
        return this.mainList.indexOf(p);
    }

    public BugLeafNode getUnfiltered(int index) {
        return this.mainList.get(index);
    }

    @Override
    public Iterator<BugLeafNode> iterator() {
        return this.mainList.iterator();
    }

    BugSet(ArrayList<BugLeafNode> filteredSet, boolean cacheSortables) {
        this.mainList = new ArrayList<BugLeafNode>(filteredSet);
        this.doneMap = new HashMap();
        this.doneContainsMap = new HashMap();
        if (cacheSortables) {
            this.cacheSortables();
        }
    }

    private BugSet filteredBugsNoCache() {
        ArrayList<BugLeafNode> people = new ArrayList<BugLeafNode>();
        for (BugLeafNode p : this.mainList) {
            if (BugSet.suppress(p)) continue;
            people.add(p);
        }
        return new BugSet(people, false);
    }

    public void clearCache() {
        this.cache = null;
    }

    private BugSet filteredBugsCached() {
        if (this.cache == null) {
            this.cache = this.filteredBugsNoCache();
        }
        return this.cache;
    }

    public BugSet getBugsMatchingFilter(Matcher m) {
        ArrayList<BugLeafNode> people = new ArrayList<BugLeafNode>();
        for (BugLeafNode p : this.mainList) {
            if (m.match(p.getBug())) continue;
            people.add(p);
        }
        return new BugSet(people, false);
    }

    public int size() {
        return this.filteredBugsCached().sizeUnfiltered();
    }

    public int indexOf(BugLeafNode p) {
        return this.filteredBugsCached().indexOfUnfiltered(p);
    }

    public BugLeafNode get(int index) {
        return this.filteredBugsCached().getUnfiltered(index);
    }
}

