/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class SuperfluousInstanceOf
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ALOAD = 1;
    private final BugReporter bugReporter;
    private LocalVariableTable varTable;
    private int state;
    private int register;

    public SuperfluousInstanceOf(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        this.state = 0;
        this.varTable = obj.getLocalVariableTable();
        if (this.varTable != null) {
            super.visit(obj);
        }
    }

    @Override
    public void visit(Code obj) {
        if (this.varTable != null) {
            super.visit(obj);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen == 25) {
                    this.register = this.getRegisterOperand();
                } else if (seen >= 42 && seen <= 45) {
                    this.register = seen - 42;
                } else {
                    return;
                }
                this.state = 1;
                break;
            }
            case 1: {
                try {
                    String objSignature;
                    LocalVariable lv;
                    if (seen == 193 && (lv = LVTHelper.getLocalVariableAtPC(this.varTable, this.register, this.getPC())) != null && (objSignature = lv.getSignature()).charAt(0) == 'L') {
                        objSignature = objSignature.substring(1, objSignature.length() - 1).replace('/', '.');
                        String clsSignature = this.getDottedClassConstantOperand();
                        if (clsSignature.charAt(0) != '[' && Repository.instanceOf(objSignature, clsSignature)) {
                            this.bugReporter.reportBug(new BugInstance(this, "SIO_SUPERFLUOUS_INSTANCEOF", 3).addClassAndMethod(this).addSourceLine(this));
                        }
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                }
                this.state = 0;
                break;
            }
        }
    }
}

