/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class AnalysisCacheToRepositoryAdapter
implements Repository {
    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaClass findClass(String className) {
        String slashedClassName = ClassName.toSlashedClassName(className);
        ClassDescriptor classDescriptor = DescriptorFactory.instance().getClassDescriptor(slashedClassName);
        return Global.getAnalysisCache().probeClassAnalysis(JavaClass.class, classDescriptor);
    }

    @Override
    public ClassPath getClassPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className.length() == 0) {
            throw new IllegalArgumentException("Request to load empty class");
        }
        className = ClassName.toSlashedClassName(className);
        ClassDescriptor classDescriptor = DescriptorFactory.instance().getClassDescriptor(className);
        try {
            return Global.getAnalysisCache().getClassAnalysis(JavaClass.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className, e);
        }
    }

    @Override
    public JavaClass loadClass(Class<?> cls) throws ClassNotFoundException {
        return this.loadClass(cls.getName());
    }

    @Override
    public void removeClass(JavaClass arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeClass(JavaClass cls) {
        throw new UnsupportedOperationException();
    }
}

