/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class MineBugHistory {
    private static final int WIDTH = 12;
    static final int ADDED = 0;
    static final int NEWCODE = 1;
    static final int REMOVED = 2;
    static final int REMOVEDCODE = 3;
    static final int RETAINED = 4;
    static final int DEAD = 5;
    static final int ACTIVE_NOW = 6;
    static final int TUPLE_SIZE = 7;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.ENGLISH);
    SortedBugCollection bugCollection;
    Version[] versionList;
    Map<Long, AppVersion> sequenceToAppVersionMap = new HashMap<Long, AppVersion>();
    boolean formatDates = false;
    boolean noTabs = false;
    boolean summary = false;
    boolean xml = false;

    public MineBugHistory() {
    }

    public MineBugHistory(SortedBugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setBugCollection(SortedBugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setFormatDates(boolean value) {
        this.formatDates = value;
    }

    public void setNoTabs() {
        this.xml = false;
        this.noTabs = true;
        this.summary = false;
    }

    public void setXml() {
        this.xml = true;
        this.noTabs = false;
        this.summary = false;
    }

    public void setSummary() {
        this.xml = false;
        this.summary = true;
        this.noTabs = false;
    }

    public MineBugHistory execute() {
        long sequenceNumber = this.bugCollection.getSequenceNumber();
        int maxSequence = (int)sequenceNumber;
        this.versionList = new Version[maxSequence + 1];
        for (int i = 0; i <= maxSequence; ++i) {
            this.versionList[i] = new Version(i);
        }
        Iterator<AppVersion> i = this.bugCollection.appVersionIterator();
        while (i.hasNext()) {
            AppVersion appVersion = i.next();
            long versionSequenceNumber = appVersion.getSequenceNumber();
            this.sequenceToAppVersionMap.put(versionSequenceNumber, appVersion);
        }
        AppVersion currentAppVersion = this.bugCollection.getCurrentAppVersion();
        this.sequenceToAppVersionMap.put(sequenceNumber, currentAppVersion);
        for (BugInstance bugInstance : this.bugCollection) {
            for (int i2 = 0; i2 <= maxSequence; ++i2) {
                boolean activeCurrent;
                if (bugInstance.getFirstVersion() > (long)i2) continue;
                boolean activePrevious = bugInstance.getFirstVersion() < (long)i2 && (!bugInstance.isDead() || bugInstance.getLastVersion() >= (long)(i2 - 1));
                int key = this.getKey(activePrevious, activeCurrent = !bugInstance.isDead() || bugInstance.getLastVersion() >= (long)i2);
                if (key == 2 && !bugInstance.isRemovedByChangeOfPersistingClass()) {
                    key = 3;
                } else if (key == 0 && !bugInstance.isIntroducedByChangeOfExistingClass()) {
                    key = 1;
                }
                this.versionList[i2].increment(key);
            }
        }
        return this;
    }

    public void dump(PrintStream out) {
        if (this.xml) {
            this.dumpXml(out);
        } else if (this.noTabs) {
            this.dumpNoTabs(out);
        } else if (this.summary) {
            this.dumpSummary(out);
        } else {
            this.dumpOriginal(out);
        }
    }

    public void dumpSummary(PrintStream out) {
        StringBuilder b = new StringBuilder();
        for (int i = Math.max(0, this.versionList.length - 10); i < this.versionList.length; ++i) {
            int paddingNeeded;
            Version version = this.versionList[i];
            int added = version.get(0) + version.get(1);
            int removed = version.get(2) + version.get(3);
            b.append(" ");
            if (added > 0) {
                b.append('+');
                b.append(added);
            }
            if (removed > 0) {
                b.append('-');
                b.append(removed);
            }
            if (added == 0 && removed == 0) {
                b.append('0');
            }
            if ((paddingNeeded = 12 - b.length() % 12) <= 0) continue;
            b.append("                                                     ".substring(0, paddingNeeded));
        }
        int errors = this.bugCollection.getErrors().size();
        if (errors > 0) {
            b.append("     ").append(errors).append(" errors");
        }
        out.println(b.toString());
    }

    public void dumpOriginal(PrintStream out) {
        out.println("seq\tversion\ttime\tclasses\tNCSS\tadded\tnewCode\tfixed\tremoved\tretained\tdead\tactive");
        for (int i = 0; i < this.versionList.length; ++i) {
            Version version = this.versionList[i];
            AppVersion appVersion = this.sequenceToAppVersionMap.get(version.getSequence());
            out.print(i);
            out.print('\t');
            out.print(appVersion != null ? appVersion.getReleaseName() : "");
            out.print('\t');
            if (this.formatDates) {
                out.print("\"" + (appVersion != null ? this.dateFormat.format(new Date(appVersion.getTimestamp())) : "") + "\"");
            } else {
                out.print(appVersion != null ? appVersion.getTimestamp() / 1000L : 0L);
            }
            out.print('\t');
            if (appVersion != null) {
                out.print(appVersion.getNumClasses());
                out.print('\t');
                out.print(appVersion.getCodeSize());
            } else {
                out.print("\t0\t0");
            }
            for (int j = 0; j < 7; ++j) {
                out.print('\t');
                out.print(version.get(j));
            }
            out.println();
        }
    }

    private static void pad(int width, PrintStream out) {
        while (width-- > 0) {
            out.print(' ');
        }
    }

    private static void print(int width, boolean alignRight, PrintStream out, Object obj) {
        String s = String.valueOf(obj);
        int padLen = width - s.length();
        if (alignRight) {
            MineBugHistory.pad(padLen, out);
        }
        out.print(s);
        if (!alignRight) {
            MineBugHistory.pad(padLen, out);
        }
    }

    public void dumpNoTabs(PrintStream out) {
        MineBugHistory.print(3, true, out, "seq");
        out.print(' ');
        MineBugHistory.print(19, false, out, "version");
        out.print(' ');
        MineBugHistory.print(this.formatDates ? 12 : 10, false, out, "time");
        MineBugHistory.print(8, true, out, "classes");
        MineBugHistory.print(13, true, out, "NCSS");
        MineBugHistory.print(13, true, out, "added");
        MineBugHistory.print(13, true, out, "newCode");
        MineBugHistory.print(13, true, out, "fixed");
        MineBugHistory.print(13, true, out, "removed");
        MineBugHistory.print(13, true, out, "retained");
        MineBugHistory.print(13, true, out, "dead");
        MineBugHistory.print(13, true, out, "active");
        out.println();
        for (int i = 0; i < this.versionList.length; ++i) {
            long ts;
            Version version = this.versionList[i];
            AppVersion appVersion = this.sequenceToAppVersionMap.get(version.getSequence());
            MineBugHistory.print(3, true, out, i);
            out.print(' ');
            MineBugHistory.print(19, false, out, appVersion != null ? appVersion.getReleaseName() : "");
            out.print(' ');
            long l = ts = appVersion != null ? appVersion.getTimestamp() : 0L;
            if (this.formatDates) {
                MineBugHistory.print(12, false, out, this.dateFormat.format(ts));
            } else {
                MineBugHistory.print(10, false, out, ts / 1000L);
            }
            out.print(' ');
            MineBugHistory.print(7, true, out, appVersion != null ? appVersion.getNumClasses() : 0);
            out.print(' ');
            MineBugHistory.print(12, true, out, appVersion != null ? appVersion.getCodeSize() : 0);
            for (int j = 0; j < 7; ++j) {
                out.print(' ');
                MineBugHistory.print(12, true, out, version.get(j));
            }
            out.println();
        }
    }

    public void dumpXml(PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<history>");
        String startData = "    <data ";
        String stop = "/>";
        for (int i = 0; i < this.versionList.length; ++i) {
            Version version = this.versionList[i];
            AppVersion appVersion = this.sequenceToAppVersionMap.get(version.getSequence());
            out.print("  <historyItem ");
            out.print("seq=\"");
            out.print(i);
            out.print("\" ");
            out.print("version=\"");
            out.print(appVersion != null ? appVersion.getReleaseName() : "");
            out.print("\" ");
            out.print("time=\"");
            if (this.formatDates) {
                out.print(appVersion != null ? new Date(appVersion.getTimestamp()).toString() : "");
            } else {
                out.print(appVersion != null ? appVersion.getTimestamp() : 0L);
            }
            out.print("\"");
            out.println(">");
            String[] attributeName = new String[]{"added", "newCode", "fixed", "removed", "retained", "dead", "active"};
            for (int j = 0; j < 7; ++j) {
                if (j == 1 || j == 4) continue;
                out.print(startData + " name=\"" + attributeName[j] + "\" value=\"");
                out.print(version.get(j));
                out.print("\"");
                out.println(stop);
            }
            out.println("  </historyItem>");
        }
        out.print("</history>");
    }

    private int getKey(boolean activePrevious, boolean activeCurrent) {
        if (activePrevious) {
            return activeCurrent ? 4 : 2;
        }
        return activeCurrent ? 0 : 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        MineBugHistory mineBugHistory = new MineBugHistory();
        MineBugHistoryCommandLine commandLine = mineBugHistory.new MineBugHistoryCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + MineBugHistory.class.getName() + " [options] [<xml results> [<history]] ");
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        mineBugHistory.setBugCollection(bugCollection);
        mineBugHistory.execute();
        try (PrintStream out = System.out;){
            if (argCount < args.length) {
                out = UTF8.printStream(new FileOutputStream(args[argCount++]), true);
            }
            mineBugHistory.dump(out);
        }
    }

    class MineBugHistoryCommandLine
    extends CommandLine {
        MineBugHistoryCommandLine() {
            this.addSwitch("-formatDates", "render dates in textual form");
            this.addSwitch("-noTabs", "delimit columns with groups of spaces for better alignment");
            this.addSwitch("-xml", "output in XML format");
            this.addSwitch("-summary", "just summarize changes over the last ten entries");
        }

        @Override
        public void handleOption(String option, String optionalExtraPart) {
            if ("-formatDates".equals(option)) {
                MineBugHistory.this.setFormatDates(true);
            } else if ("-noTabs".equals(option)) {
                MineBugHistory.this.setNoTabs();
            } else if ("-xml".equals(option)) {
                MineBugHistory.this.setXml();
            } else if ("-summary".equals(option)) {
                MineBugHistory.this.setSummary();
            } else {
                throw new IllegalArgumentException("unknown option: " + option);
            }
        }

        @Override
        public void handleOptionWithArgument(String option, String argument) {
            throw new IllegalArgumentException("unknown option: " + option);
        }
    }

    static class Version {
        long sequence;
        int[] tuple = new int[7];

        Version(long sequence) {
            this.sequence = sequence;
        }

        public long getSequence() {
            return this.sequence;
        }

        void increment(int key) {
            int n = key;
            this.tuple[n] = this.tuple[n] + 1;
            if (key == 0 || key == 4 || key == 1) {
                this.tuple[6] = this.tuple[6] + 1;
            }
        }

        int get(int key) {
            return this.tuple[key];
        }
    }
}

