/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.AWTEventQueueExecutor;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.gui2.DisplayNonmodelMessage;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class AbstractSwingGuiCallback
implements IGuiCallback {
    private final AWTEventQueueExecutor bugUpdateExecutor = new AWTEventQueueExecutor();
    private final Component parent;

    public AbstractSwingGuiCallback(Component parent) {
        this.parent = parent;
    }

    @Override
    public ExecutorService getBugUpdateExecutor() {
        return this.bugUpdateExecutor;
    }

    @Override
    public void showMessageDialogAndWait(final String message) throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this.parent, message);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(AbstractSwingGuiCallback.this.parent, message);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void showMessageDialog(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this.parent, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(AbstractSwingGuiCallback.this.parent, message);
                }
            });
        }
    }

    @Override
    public int showConfirmDialog(String message, String title, String ok, String cancel) {
        return JOptionPane.showOptionDialog(this.parent, message, title, 2, -1, null, new Object[]{ok, cancel}, ok);
    }

    @Override
    public InputStream getProgressMonitorInputStream(InputStream in, int length, String msg) {
        ProgressMonitorInputStream pmin = new ProgressMonitorInputStream(this.parent, msg, in);
        ProgressMonitor pm = pmin.getProgressMonitor();
        if (length > 0) {
            pm.setMaximum(length);
        }
        return pmin;
    }

    @Override
    public void displayNonmodelMessage(String title, String message) {
        DisplayNonmodelMessage.displayNonmodelMessage(title, message, this.parent, true);
    }

    @Override
    public String showQuestionDialog(String message, String title, String defaultValue) {
        return (String)JOptionPane.showInputDialog(this.parent, message, title, 3, null, null, defaultValue);
    }

    @Override
    public List<String> showForm(String message, String title, List<IGuiCallback.FormItem> items) {
        int result = this.showFormDialog(message, title, items);
        if (result != 0) {
            return null;
        }
        this.updateFormItemsFromGui(items);
        ArrayList<String> results = new ArrayList<String>();
        for (IGuiCallback.FormItem item : items) {
            results.add(item.getCurrentValue());
        }
        return results;
    }

    @Override
    public boolean showDocument(URL u) {
        return LaunchBrowser.showDocument(u);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public void invokeInGUIThread(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    private void updateFormItemsFromGui(List<IGuiCallback.FormItem> items) {
        for (IGuiCallback.FormItem item : items) {
            JComponent field = item.getField();
            if (field instanceof JTextComponent) {
                JTextComponent textComponent = (JTextComponent)field;
                item.setCurrentValue(textComponent.getText());
            } else if (field instanceof JComboBox) {
                JComboBox box = (JComboBox)field;
                String value = (String)box.getSelectedItem();
                item.setCurrentValue(value);
            }
            item.updated();
        }
        this.updateComboBoxes(items);
    }

    private void updateComboBoxes(List<IGuiCallback.FormItem> items) {
        for (IGuiCallback.FormItem item : items) {
            List<String> newPossibleValues;
            JComboBox box;
            JComponent field = item.getField();
            if (!(field instanceof JComboBox) || this.boxModelIsSame(box = (JComboBox)field, newPossibleValues = item.getPossibleValues())) continue;
            MutableComboBoxModel mmodel = (MutableComboBoxModel)box.getModel();
            this.replaceBoxModelValues(mmodel, newPossibleValues);
            mmodel.setSelectedItem(item.getCurrentValue());
        }
    }

    private void replaceBoxModelValues(MutableComboBoxModel<String> mmodel, List<String> newPossibleValues) {
        try {
            while (mmodel.getSize() > 0) {
                mmodel.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String value : newPossibleValues) {
            mmodel.addElement(value);
        }
    }

    private boolean boxModelIsSame(JComboBox<String> box, List<String> newPossibleValues) {
        boolean same = true;
        if (box.getModel().getSize() != newPossibleValues.size()) {
            same = false;
        } else {
            for (int i = 0; i < box.getModel().getSize(); ++i) {
                if (((String)box.getModel().getElementAt(i)).equals(newPossibleValues.get(i))) continue;
                same = false;
                break;
            }
        }
        return same;
    }

    private int showFormDialog(String message, String title, List<IGuiCallback.FormItem> items) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JLabel(message), gbc);
        gbc.gridwidth = 1;
        for (IGuiCallback.FormItem item : items) {
            item.setItems(items);
            ++gbc.gridy;
            panel.add((Component)new JLabel(item.getLabel()), gbc);
            String defaultValue = item.getDefaultValue();
            if (item.getPossibleValues() != null) {
                JComboBox<String> box = this.createComboBox(items, item);
                panel.add(box, gbc);
                continue;
            }
            JTextField field = this.createTextField(items, item);
            panel.add((Component)field, gbc);
        }
        return JOptionPane.showConfirmDialog(this.parent, panel, title, 2);
    }

    private JTextField createTextField(final List<IGuiCallback.FormItem> items, IGuiCallback.FormItem item) {
        JTextField field;
        String defaultValue = item.getDefaultValue();
        JTextField jTextField = field = item.isPassword() ? new JPasswordField() : new JTextField();
        if (defaultValue != null) {
            field.setText(defaultValue);
        }
        item.setField(field);
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                AbstractSwingGuiCallback.this.updateFormItemsFromGui(items);
            }
        });
        return field;
    }

    private JComboBox<String> createComboBox(final List<IGuiCallback.FormItem> items, IGuiCallback.FormItem item) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        JComboBox<String> box = new JComboBox<String>(model);
        item.setField(box);
        for (String possibleValue : item.getPossibleValues()) {
            model.addElement(possibleValue);
        }
        String defaultValue = item.getDefaultValue();
        if (defaultValue == null) {
            model.setSelectedItem(model.getElementAt(0));
        } else {
            model.setSelectedItem(defaultValue);
        }
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSwingGuiCallback.this.updateFormItemsFromGui(items);
            }
        });
        return box;
    }
}

