/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.UnreadFieldsData;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.bcel.classfile.JavaClass;

public class ExplicitSerialization
extends OpcodeStackDetector
implements NonReportingDetector {
    static final XMethod writeObject = XFactory.createXMethod("java.io.ObjectOutputStream", "writeObject", "(Ljava/lang/Object;)V", false);
    static final XMethod readObject = XFactory.createXMethod("java.io.ObjectInputStream", "readObject", "()Ljava/lang/Object;", false);
    static final ClassDescriptor ObjectOutputStream = DescriptorFactory.createClassDescriptor(ObjectOutputStream.class);
    static final ClassDescriptor ObjectInputStream = DescriptorFactory.createClassDescriptor(ObjectInputStream.class);
    final UnreadFieldsData unreadFields;
    final BugReporter bugReporter;

    public ExplicitSerialization(BugReporter bugReporter) {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        this.unreadFields = context.getUnreadFieldsData();
        this.bugReporter = bugReporter;
    }

    @Override
    public boolean shouldVisit(JavaClass obj) {
        XClass xClass = this.getXClass();
        return xClass.getCalledClassDescriptors().contains(ObjectOutputStream) || xClass.getCalledClassDescriptors().contains(ObjectInputStream);
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item top;
        if (seen == 182 && writeObject.equals(this.getXMethodOperand())) {
            top = this.stack.getStackItem(0);
            String signature = top.getSignature();
            while (signature.charAt(0) == '[') {
                signature = signature.substring(1);
            }
            ClassDescriptor c = DescriptorFactory.createClassDescriptorFromFieldSignature(signature);
            if (c == null || !Subtypes2.instanceOf(c, Serializable.class)) {
                return;
            }
            try {
                XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
                if (xClass.isInterface()) {
                    return;
                }
                if (xClass.isSynthetic()) {
                    return;
                }
                if (xClass.isAbstract()) {
                    return;
                }
                this.unreadFields.strongEvidenceForIntendedSerialization(c);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Error looking up xClass of " + c, e);
            }
        }
        if (seen == 192 && readObject.equals((top = this.stack.getStackItem(0)).getReturnValueOf())) {
            ClassDescriptor c = this.getClassDescriptorOperand();
            if (!Subtypes2.instanceOf(c, Serializable.class)) {
                return;
            }
            try {
                XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
                if (xClass.isInterface()) {
                    return;
                }
                if (xClass.isSynthetic()) {
                    return;
                }
                if (xClass.isAbstract()) {
                    return;
                }
                this.unreadFields.strongEvidenceForIntendedSerialization(c);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Error looking up xClass of " + c, e);
            }
        }
    }
}

