/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;

public class ConfusionBetweenInheritedAndOuterMethod
extends OpcodeStackDetector {
    BugAccumulator bugAccumulator;
    BugInstance iteratorBug;
    boolean isInnerClass;

    public ConfusionBetweenInheritedAndOuterMethod(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitJavaClass(JavaClass obj) {
        this.isInnerClass = false;
        if (obj.getClassName().indexOf(36) >= 0) {
            super.visitJavaClass(obj);
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    @Override
    public void visit(Field f) {
        if (f.getName().startsWith("this$")) {
            this.isInnerClass = true;
        }
    }

    @Override
    public void visit(Code obj) {
        if (this.isInnerClass && !BCELUtil.isSynthetic(this.getMethod())) {
            super.visit(obj);
            this.iteratorBug = null;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        int i;
        if (this.iteratorBug != null) {
            LocalVariable localVariable;
            LocalVariableTable lvt;
            if (this.isRegisterStore() && (lvt = this.getMethod().getLocalVariableTable()) != null && ((localVariable = lvt.getLocalVariable(this.getRegisterOperand(), this.getNextPC())) == null || localVariable.getName().endsWith("$"))) {
                this.iteratorBug = null;
            }
            if (this.iteratorBug != null) {
                this.bugAccumulator.accumulateBug(this.iteratorBug, this);
            }
            this.iteratorBug = null;
        }
        if (seen != 182) {
            return;
        }
        if (!this.getClassName().equals(this.getClassConstantOperand())) {
            return;
        }
        XMethod invokedMethod = XFactory.createXMethod(this.getDottedClassConstantOperand(), this.getNameConstantOperand(), this.getSigConstantOperand(), false);
        if (invokedMethod.isResolved() && invokedMethod.getClassName().equals(this.getDottedClassConstantOperand()) || invokedMethod.isSynthetic()) {
            return;
        }
        if (this.getStack().getStackItem(ConfusionBetweenInheritedAndOuterMethod.getNumberArguments(this.getSigConstantOperand())).getRegisterNumber() != 0) {
            return;
        }
        String possibleTargetClass = this.getDottedClassName();
        String superClassName = this.getDottedSuperclassName();
        while ((i = possibleTargetClass.lastIndexOf(36)) > 0 && !(possibleTargetClass = possibleTargetClass.substring(0, i)).equals(superClassName)) {
            XMethod alternativeMethod = XFactory.createXMethod(possibleTargetClass, this.getNameConstantOperand(), this.getSigConstantOperand(), false);
            if (!alternativeMethod.isResolved() || !alternativeMethod.getClassName().equals(possibleTargetClass)) continue;
            String targetPackage = invokedMethod.getPackageName();
            String alternativePackage = alternativeMethod.getPackageName();
            int priority = 1;
            if (targetPackage.equals(alternativePackage)) {
                ++priority;
            }
            if (targetPackage.startsWith("javax.swing") || targetPackage.startsWith("java.awt")) {
                priority += 2;
            }
            if (invokedMethod.getName().equals(this.getMethodName())) {
                ++priority;
            }
            BugInstance bug = new BugInstance(this, "IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD", priority).addClassAndMethod(this).addMethod(invokedMethod).describe("METHOD_INHERITED").addMethod(alternativeMethod).describe("METHOD_ALTERNATIVE_TARGET");
            if (invokedMethod.getName().equals("iterator") && invokedMethod.getSignature().equals("()Ljava/util/Iterator;") && Subtypes2.instanceOf(this.getDottedClassName(), "java.lang.Iterable")) {
                this.iteratorBug = bug;
                break;
            }
            this.bugAccumulator.accumulateBug(bug, this);
            break;
        }
    }
}

