/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SAXBugCollectionHandler;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudFactory;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.model.ClassFeatureSet;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.Dom4JXMLOutput;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutputUtil;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.xml.transform.TransformerException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SortedBugCollection
implements BugCollection {
    private static final Logger LOGGER = Logger.getLogger(SortedBugCollection.class.getName());
    private static final boolean REPORT_SUMMARY_HTML = SystemProperties.getBoolean("findbugs.report.SummaryHTML");
    long analysisTimestamp = System.currentTimeMillis();
    String analysisVersion = Version.RELEASE;
    boolean earlyStats = SystemProperties.getBoolean("findbugs.report.summaryFirst");
    boolean bugsPopulated = false;
    private boolean withMessages = false;
    private boolean minimalXML = false;
    private boolean applySuppressions = false;
    @CheckForNull
    private Cloud cloud;
    boolean shouldNotUsePlugin;
    long timeStartedLoading;
    long timeFinishedLoading;
    String dataSource = "";
    private Map<String, String> xmlCloudDetails = Collections.emptyMap();
    private final Comparator<BugInstance> comparator;
    private final TreeSet<BugInstance> bugSet;
    private final LinkedHashSet<AnalysisError> errorList;
    private final TreeSet<String> missingClassSet;
    @CheckForNull
    private String summaryHTML;
    final Project project;
    private final ProjectStats projectStats;
    private final Map<String, ClassFeatureSet> classFeatureSetMap;
    private final List<AppVersion> appVersionList;
    private boolean preciseHashOccurrenceNumbersAvailable = false;
    private long sequence;
    private String releaseName;
    private long timestamp;

    public long getTimeStartedLoading() {
        return this.timeStartedLoading;
    }

    public long getTimeFinishedLoading() {
        return this.timeFinishedLoading;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    @CheckForNull
    public Cloud getCloudLazily() {
        if (this.cloud != null && this.bugsPopulated) {
            this.cloud.bugsPopulated();
        }
        return this.cloud;
    }

    @Override
    @Nonnull
    public Cloud getCloud() {
        if (this.shouldNotUsePlugin) {
            return CloudFactory.getPlainCloud(this);
        }
        Cloud result = this.cloud;
        if (result == null) {
            IGuiCallback callback = this.getProject().getGuiCallback();
            result = this.cloud = CloudFactory.createCloudWithoutInitializing(this);
            try {
                CloudFactory.initializeCloud(this, result);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not load cloud plugin " + result.getCloudName(), e);
                callback.showMessageDialog("Unable to connect to " + result.getCloudName() + ": " + Util.getNetworkErrorMessage(e));
                if (CloudFactory.FAIL_ON_CLOUD_ERROR) {
                    throw new IllegalStateException("Could not load FindBugs Cloud plugin - to avoid this message, set -Dfindbugs.failOnCloudError=false", e);
                }
                result = this.cloud = CloudFactory.getPlainCloud(this);
            }
            callback.registerCloud(this.getProject(), this, result);
        }
        if (!result.isInitialized()) {
            LOGGER.log(Level.SEVERE, "Cloud " + result.getCloudName() + " is not initialized ");
        }
        if (this.bugsPopulated) {
            result.bugsPopulated();
        }
        return result;
    }

    @Override
    public boolean isApplySuppressions() {
        return this.applySuppressions;
    }

    @Override
    public void setApplySuppressions(boolean applySuppressions) {
        this.applySuppressions = applySuppressions;
    }

    @Override
    public long getAnalysisTimestamp() {
        return this.analysisTimestamp;
    }

    @Override
    public void setAnalysisTimestamp(long timestamp) {
        this.analysisTimestamp = timestamp;
    }

    public void addAll(Collection<BugInstance> collection) {
        for (BugInstance bug : collection) {
            this.add(bug);
        }
    }

    public void addAll(Collection<BugInstance> collection, boolean updateActiveTime) {
        for (BugInstance warning : collection) {
            this.add(warning, updateActiveTime);
        }
    }

    @Override
    public boolean add(BugInstance bugInstance) {
        return this.add(bugInstance, bugInstance.getFirstVersion() == 0L && bugInstance.getLastVersion() == 0L);
    }

    @Override
    public void addError(String message) {
        this.addError(message, null);
    }

    @Override
    public AppVersion getCurrentAppVersion() {
        return new AppVersion(this.getSequenceNumber()).setReleaseName(this.getReleaseName()).setTimestamp(this.getTimestamp()).setNumClasses(this.getProjectStats().getNumClasses()).setCodeSize(this.getProjectStats().getCodeSize());
    }

    @Override
    public void readXML(String fileName) throws IOException, DocumentException {
        this.readXML(new File(fileName));
    }

    public void readXML(File file) throws IOException, DocumentException {
        this.project.setCurrentWorkingDirectory(file.getParentFile());
        this.dataSource = file.getAbsolutePath();
        InputStream in = this.progessMonitoredInputStream(file, "Loading analysis");
        try {
            this.readXML(in, file);
        }
        catch (IOException e) {
            throw SortedBugCollection.newIOException(file, e);
        }
        catch (DocumentException e) {
            throw new DocumentException("Failing reading " + file, (Throwable)e);
        }
    }

    private static IOException newIOException(Object file, IOException e) {
        IOException result = new IOException("Failing reading " + file);
        result.initCause(e);
        return result;
    }

    public void readXML(URL u) throws IOException, DocumentException {
        InputStream in = this.progessMonitoredInputStream(u.openConnection(), "Loading analysis");
        this.dataSource = u.toString();
        try {
            this.readXML(in);
        }
        catch (IOException e) {
            throw SortedBugCollection.newIOException(u, e);
        }
        catch (DocumentException e) {
            throw new DocumentException("Failing reading " + u, (Throwable)e);
        }
    }

    public void readXML(@WillClose InputStream in, File base) throws IOException, DocumentException {
        try {
            this.doReadXML(in, base);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void readXML(@WillClose InputStream in) throws IOException, DocumentException {
        assert (this.project != null);
        assert (in != null);
        this.doReadXML(in, null);
    }

    @Override
    public void readXML(@WillClose Reader reader) throws IOException, DocumentException {
        assert (this.project != null);
        assert (reader != null);
        this.doReadXML(reader, null);
    }

    private void doReadXML(@WillClose InputStream in, @CheckForNull File base) throws IOException, DocumentException {
        try {
            SortedBugCollection.checkInputStream(in);
            Reader reader = Util.getReader(in);
            this.doReadXML(reader, base);
        }
        catch (RuntimeException e) {
            in.close();
            throw e;
        }
        catch (IOException e) {
            in.close();
            throw e;
        }
    }

    private void doReadXML(@WillClose Reader reader, @CheckForNull File base) throws IOException, DocumentException {
        this.timeStartedLoading = System.currentTimeMillis();
        SAXBugCollectionHandler handler = new SAXBugCollectionHandler(this, base);
        Profiler profiler = this.getProjectStats().getProfiler();
        profiler.start(handler.getClass());
        try {
            XMLReader xr;
            try {
                xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                AnalysisContext.logError("Couldn't create XMLReaderFactory", e);
                throw new DocumentException("Sax error ", (Throwable)e);
            }
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(new InputSource(reader));
        }
        catch (SAXParseException e) {
            if (base != null) {
                throw new DocumentException("Parse error at line " + e.getLineNumber() + " : " + e.getColumnNumber() + " of " + base, (Throwable)e);
            }
            throw new DocumentException("Parse error at line " + e.getLineNumber() + " : " + e.getColumnNumber(), (Throwable)e);
        }
        catch (SAXException e) {
            if (base != null) {
                throw new DocumentException("Sax error while parsing " + base, (Throwable)e);
            }
            throw new DocumentException("Sax error ", (Throwable)e);
        }
        finally {
            Util.closeSilently(reader);
            profiler.end(handler.getClass());
        }
        this.timeFinishedLoading = System.currentTimeMillis();
        this.bugsPopulated();
        this.project.setModified(false);
    }

    @Override
    public void writeXML(OutputStream out) throws IOException {
        this.writeXML(UTF8.writer(out));
    }

    @Override
    public void writeXML(String fileName) throws IOException {
        OutputStream out = new FileOutputStream(fileName);
        if (fileName.endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        this.writeXML(out);
    }

    public void writeXML(File file) throws IOException {
        OutputStream out = new FileOutputStream(file);
        if (file.getName().endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        this.writeXML(out);
    }

    @Override
    public Document toDocument() {
        assert (this.project != null);
        DocumentFactory docFactory = new DocumentFactory();
        Document document = docFactory.createDocument();
        Dom4JXMLOutput treeBuilder = new Dom4JXMLOutput((Branch)document);
        try {
            this.writeXML(treeBuilder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return document;
    }

    @Override
    public void writeXML(@WillClose Writer out) throws IOException {
        OutputStreamXMLOutput xmlOutput;
        assert (this.project != null);
        this.bugsPopulated();
        if (this.withMessages && this.cloud != null) {
            this.cloud.bugsPopulated();
            this.cloud.initiateCommunication();
            this.cloud.waitUntilIssueDataDownloaded();
            String token = SystemProperties.getProperty("findbugs.cloud.token");
            if (token != null && token.trim().length() > 0) {
                LOGGER.info("Cloud token specified - uploading new issues, if necessary...");
                this.cloud.waitUntilNewIssuesUploaded();
            }
            xmlOutput = new OutputStreamXMLOutput(out, "http://findbugs.sourceforge.net/xsl/default.xsl");
        } else {
            xmlOutput = new OutputStreamXMLOutput(out);
        }
        this.writeXML(xmlOutput);
    }

    @Override
    public void writePrologue(XMLOutput xmlOutput) throws IOException {
        xmlOutput.beginDocument();
        xmlOutput.openTag("BugCollection", new XMLAttributeList().addAttribute("version", this.analysisVersion).addAttribute("sequence", String.valueOf(this.getSequenceNumber())).addAttribute("timestamp", String.valueOf(this.getTimestamp())).addAttribute("analysisTimestamp", String.valueOf(this.getAnalysisTimestamp())).addAttribute("release", this.getReleaseName()));
        this.project.writeXML(xmlOutput, null, this);
    }

    public void computeBugHashes() {
        if (this.preciseHashOccurrenceNumbersAvailable) {
            return;
        }
        this.invalidateHashes();
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        for (BugInstance bugInstance : this.getCollection()) {
            String hash = bugInstance.getInstanceHash();
            Integer count = (Integer)seen.get(hash);
            if (count == null) {
                bugInstance.setInstanceOccurrenceNum(0);
                seen.put(hash, 0);
                continue;
            }
            bugInstance.setInstanceOccurrenceNum(count + 1);
            seen.put(hash, count + 1);
        }
        for (BugInstance bugInstance : this.getCollection()) {
            bugInstance.setInstanceOccurrenceMax((Integer)seen.get(bugInstance.getInstanceHash()));
        }
        this.preciseHashOccurrenceNumbersAvailable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXML(@WillClose XMLOutput xmlOutput) throws IOException {
        assert (this.project != null);
        try {
            this.writePrologue(xmlOutput);
            if (this.withMessages) {
                this.computeBugHashes();
                this.getProjectStats().computeFileStats(this);
                String commonBase = null;
                for (String s : this.project.getSourceDirList()) {
                    if (commonBase == null) {
                        commonBase = s;
                        continue;
                    }
                    commonBase = commonBase.substring(0, this.commonPrefix(commonBase, s));
                }
                if (commonBase != null && commonBase.length() > 0) {
                    File base;
                    if (commonBase.indexOf("/./") > 0) {
                        commonBase = commonBase.substring(0, commonBase.indexOf("/."));
                    }
                    if ((base = new File(commonBase)).exists() && base.isDirectory() && base.canRead()) {
                        SourceLineAnnotation.generateRelativeSource(base, this.project);
                    }
                }
            }
            if (this.earlyStats && !this.minimalXML) {
                this.getProjectStats().writeXML(xmlOutput, this.withMessages);
            }
            for (BugInstance bugInstance : this.getCollection()) {
                if (this.applySuppressions && this.project.getSuppressionFilter().match(bugInstance)) continue;
                bugInstance.writeXML(xmlOutput, this, this.withMessages);
            }
            this.writeEpilogue(xmlOutput);
        }
        finally {
            xmlOutput.finish();
            SourceLineAnnotation.clearGenerateRelativeSource();
        }
    }

    int commonPrefix(String s1, String s2) {
        int pos;
        for (pos = 0; pos < s1.length() && pos < s2.length() && s1.charAt(pos) == s2.charAt(pos); ++pos) {
        }
        return pos;
    }

    @Override
    public void writeEpilogue(XMLOutput xmlOutput) throws IOException {
        String html;
        if (this.withMessages) {
            this.writeBugCategories(xmlOutput);
            this.writeBugPatterns(xmlOutput);
            this.writeBugCodes(xmlOutput);
        }
        if (!this.minimalXML) {
            this.emitErrors(xmlOutput);
        }
        if (!this.earlyStats && !this.minimalXML) {
            this.getProjectStats().writeXML(xmlOutput, this.withMessages);
        }
        xmlOutput.openTag("ClassFeatures");
        Iterator<XMLWriteable> i = this.classFeatureSetIterator();
        while (i.hasNext()) {
            ClassFeatureSet classFeatureSet = i.next();
            classFeatureSet.writeXML(xmlOutput);
        }
        xmlOutput.closeTag("ClassFeatures");
        xmlOutput.openTag("History");
        i = this.appVersionIterator();
        while (i.hasNext()) {
            AppVersion appVersion = (AppVersion)i.next();
            appVersion.writeXML(xmlOutput);
        }
        xmlOutput.closeTag("History");
        if (REPORT_SUMMARY_HTML && (html = this.getSummaryHTML()) != null && !"".equals(html)) {
            xmlOutput.openTag("SummaryHTML");
            xmlOutput.writeCDATA(html);
            xmlOutput.closeTag("SummaryHTML");
        }
        xmlOutput.closeTag("BugCollection");
    }

    private void writeBugPatterns(XMLOutput xmlOutput) throws IOException {
        BugPattern bugPattern;
        HashSet<String> bugTypeSet = new HashSet<String>();
        for (BugInstance bugInstance : this) {
            bugPattern = bugInstance.getBugPattern();
            bugTypeSet.add(bugPattern.getType());
        }
        for (String bugType : bugTypeSet) {
            bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(bugType);
            if (bugPattern == null) continue;
            XMLAttributeList attributeList = new XMLAttributeList();
            attributeList.addAttribute("type", bugType);
            attributeList.addAttribute("abbrev", bugPattern.getAbbrev());
            attributeList.addAttribute("category", bugPattern.getCategory());
            if (bugPattern.getCWEid() != 0) {
                attributeList.addAttribute("cweid", Integer.toString(bugPattern.getCWEid()));
            }
            xmlOutput.openTag("BugPattern", attributeList);
            xmlOutput.openTag("ShortDescription");
            xmlOutput.writeText(bugPattern.getShortDescription());
            xmlOutput.closeTag("ShortDescription");
            xmlOutput.openTag("Details");
            xmlOutput.writeCDATA(bugPattern.getDetailText());
            xmlOutput.closeTag("Details");
            xmlOutput.closeTag("BugPattern");
        }
    }

    private void writeBugCodes(XMLOutput xmlOutput) throws IOException {
        Object bugCode;
        HashSet<String> bugCodeSet = new HashSet<String>();
        for (BugInstance bugInstance : this) {
            bugCode = bugInstance.getAbbrev();
            if (bugCode == null) continue;
            bugCodeSet.add((String)bugCode);
        }
        for (String bugCodeAbbrev : bugCodeSet) {
            bugCode = DetectorFactoryCollection.instance().getBugCode(bugCodeAbbrev);
            String bugCodeDescription = ((BugCode)bugCode).getDescription();
            if (bugCodeDescription == null) continue;
            XMLAttributeList attributeList = new XMLAttributeList();
            attributeList.addAttribute("abbrev", bugCodeAbbrev);
            if (((BugCode)bugCode).getCWEid() != 0) {
                attributeList.addAttribute("cweid", Integer.toString(((BugCode)bugCode).getCWEid()));
            }
            xmlOutput.openTag("BugCode", attributeList);
            xmlOutput.openTag("Description");
            xmlOutput.writeText(bugCodeDescription);
            xmlOutput.closeTag("Description");
            xmlOutput.closeTag("BugCode");
        }
    }

    private void writeBugCategories(XMLOutput xmlOutput) throws IOException {
        HashSet<String> bugCatSet = new HashSet<String>();
        for (BugInstance bugInstance : this) {
            BugPattern bugPattern = bugInstance.getBugPattern();
            bugCatSet.add(bugPattern.getCategory());
        }
        for (String bugCat : bugCatSet) {
            String bugCatDescription = I18N.instance().getBugCategoryDescription(bugCat);
            if (bugCatDescription == null) continue;
            XMLAttributeList attributeList = new XMLAttributeList();
            attributeList.addAttribute("category", bugCat);
            xmlOutput.openTag("BugCategory", attributeList);
            xmlOutput.openTag("Description");
            xmlOutput.writeText(bugCatDescription);
            xmlOutput.closeTag("Description");
            xmlOutput.closeTag("BugCategory");
        }
    }

    private void emitErrors(XMLOutput xmlOutput) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList();
        attributeList.addAttribute("errors", Integer.toString(this.errorList.size()));
        attributeList.addAttribute("missingClasses", Integer.toString(this.missingClassSet.size()));
        xmlOutput.openTag("Errors", attributeList);
        for (AnalysisError analysisError : this.getErrors()) {
            xmlOutput.openTag("Error");
            xmlOutput.openTag("ErrorMessage");
            xmlOutput.writeText(analysisError.getMessage());
            xmlOutput.closeTag("ErrorMessage");
            if (analysisError.getExceptionMessage() != null) {
                xmlOutput.openTag("Exception");
                xmlOutput.writeText(analysisError.getExceptionMessage());
                xmlOutput.closeTag("Exception");
                String[] stackTrace = analysisError.getStackTrace();
                if (stackTrace != null) {
                    for (String aStackTrace : stackTrace) {
                        xmlOutput.openTag("StackTrace");
                        xmlOutput.writeText(aStackTrace);
                        xmlOutput.closeTag("StackTrace");
                    }
                }
            }
            xmlOutput.closeTag("Error");
        }
        XMLOutputUtil.writeElementList(xmlOutput, "MissingClass", this.missingClassIterator());
        xmlOutput.closeTag("Errors");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInputStream(@WillNotClose InputStream in) throws IOException {
        if (!in.markSupported()) {
            return;
        }
        byte[] buf = new byte[200];
        in.mark(buf.length);
        int numRead = 0;
        boolean isEOF = false;
        while (numRead < buf.length && !isEOF) {
            int n = in.read(buf, numRead, buf.length - numRead);
            if (n < 0) {
                isEOF = true;
                continue;
            }
            numRead += n;
        }
        in.reset();
        try (BufferedReader reader = new BufferedReader(Util.getReader(new ByteArrayInputStream(buf)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("<BugCollection")) continue;
                return;
            }
        }
        throw new IOException("XML does not contain saved bug data");
    }

    public static void cloneAll(Collection<BugInstance> dest, Collection<BugInstance> source) {
        for (BugInstance obj : source) {
            dest.add((BugInstance)obj.clone());
        }
    }

    public SortedBugCollection(Project project) {
        this(new ProjectStats(), MultiversionBugInstanceComparator.instance, project);
    }

    public SortedBugCollection(File f) throws IOException, DocumentException {
        this();
        this.readXML(f);
    }

    public SortedBugCollection() {
        this(new ProjectStats());
    }

    public SortedBugCollection(Comparator<BugInstance> comparator) {
        this(new ProjectStats(), comparator);
    }

    public SortedBugCollection(ProjectStats projectStats) {
        this(projectStats, MultiversionBugInstanceComparator.instance);
    }

    public SortedBugCollection(ProjectStats projectStats, Project project) {
        this(projectStats, MultiversionBugInstanceComparator.instance, project);
    }

    public SortedBugCollection(ProjectStats projectStats, Comparator<BugInstance> comparator) {
        this(projectStats, comparator, new Project());
    }

    public SortedBugCollection(ProjectStats projectStats, Comparator<BugInstance> comparator, Project project) {
        this.projectStats = projectStats;
        this.comparator = comparator;
        this.project = project;
        this.bugSet = new TreeSet<BugInstance>(comparator);
        this.errorList = new BoundedLinkedHashSet();
        this.missingClassSet = new TreeSet();
        this.summaryHTML = null;
        this.classFeatureSetMap = new TreeMap<String, ClassFeatureSet>();
        this.sequence = 0L;
        this.appVersionList = new LinkedList<AppVersion>();
        this.releaseName = "";
        this.timestamp = -1L;
    }

    @Override
    public boolean add(BugInstance bugInstance, boolean updateActiveTime) {
        assert (!this.bugsPopulated);
        if (this.bugsPopulated) {
            AnalysisContext.logError("Bug collection marked as populated, but bugs added", new RuntimeException("Bug collection marked as populated, but bugs added"));
            this.bugsPopulated = false;
        }
        this.preciseHashOccurrenceNumbersAvailable = false;
        if (updateActiveTime) {
            bugInstance.setFirstVersion(this.sequence);
        }
        this.invalidateHashes();
        if (!bugInstance.isDead()) {
            this.projectStats.addBug(bugInstance);
        }
        return this.bugSet.add(bugInstance);
    }

    private void invalidateHashes() {
        this.preciseHashOccurrenceNumbersAvailable = false;
    }

    public boolean remove(BugInstance bugInstance) {
        this.invalidateHashes();
        return this.bugSet.remove(bugInstance);
    }

    @Override
    public Iterator<BugInstance> iterator() {
        return this.bugSet.iterator();
    }

    @Override
    public Collection<BugInstance> getCollection() {
        return Collections.unmodifiableCollection(this.bugSet);
    }

    public void addError(String message, Throwable exception) {
        if (exception instanceof MissingClassException) {
            MissingClassException e = (MissingClassException)exception;
            this.addMissingClass(AbstractBugReporter.getMissingClassName(e.getClassNotFoundException()));
            return;
        }
        if (exception instanceof ClassNotFoundException) {
            ClassNotFoundException e = (ClassNotFoundException)exception;
            this.addMissingClass(AbstractBugReporter.getMissingClassName(e));
            return;
        }
        if (exception instanceof edu.umd.cs.findbugs.classfile.MissingClassException) {
            edu.umd.cs.findbugs.classfile.MissingClassException e = (edu.umd.cs.findbugs.classfile.MissingClassException)exception;
            this.addMissingClass(AbstractBugReporter.getMissingClassName(e.toClassNotFoundException()));
            return;
        }
        this.errorList.add(new AnalysisError(message, exception));
    }

    @Override
    public void addError(AnalysisError error) {
        this.errorList.add(error);
    }

    public void clearErrors() {
        this.errorList.clear();
    }

    @Override
    public void addMissingClass(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        if (className.startsWith("[")) {
            assert (false) : "Bad class name " + className;
            return;
        }
        if (className.endsWith(";")) {
            this.addError("got signature rather than classname: " + className, new IllegalArgumentException());
        } else {
            this.missingClassSet.add(className);
        }
    }

    public Collection<? extends AnalysisError> getErrors() {
        return this.errorList;
    }

    public Iterator<String> missingClassIterator() {
        return this.missingClassSet.iterator();
    }

    public boolean contains(BugInstance bugInstance) {
        return this.bugSet.contains(bugInstance);
    }

    public BugInstance getMatching(BugInstance bugInstance) {
        SortedSet<BugInstance> tailSet = this.bugSet.tailSet(bugInstance);
        if (tailSet.isEmpty()) {
            return null;
        }
        BugInstance first = tailSet.first();
        return bugInstance.equals(first) ? first : null;
    }

    public String getSummaryHTML() throws IOException {
        if (this.summaryHTML == null) {
            try {
                StringWriter writer = new StringWriter();
                ProjectStats stats = this.getProjectStats();
                stats.transformSummaryToHTML(writer);
                this.summaryHTML = writer.toString();
            }
            catch (TransformerException e) {
                IOException ioe = new IOException("Couldn't generate summary HTML");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.summaryHTML;
    }

    @Override
    public ProjectStats getProjectStats() {
        return this.projectStats;
    }

    @Override
    @Deprecated
    public BugInstance lookupFromUniqueId(String uniqueId) {
        for (BugInstance bug : this.bugSet) {
            if (!bug.getInstanceHash().equals(uniqueId)) continue;
            return bug;
        }
        return null;
    }

    @Override
    public boolean isMultiversion() {
        return this.sequence > 0L;
    }

    @Override
    public boolean hasDeadBugs() {
        if (this.sequence == 0L) {
            return false;
        }
        for (BugInstance b : this.bugSet) {
            if (!b.isDead()) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequence;
    }

    @Override
    public void setSequenceNumber(long sequence) {
        this.sequence = sequence;
    }

    public SortedBugCollection duplicate() {
        SortedBugCollection dup = this.createEmptyCollectionWithMetadata();
        SortedBugCollection.cloneAll(dup.bugSet, this.bugSet);
        return dup;
    }

    @Override
    public SortedBugCollection createEmptyCollectionWithMetadata() {
        SortedBugCollection dup = new SortedBugCollection(this.projectStats.clone(), this.comparator, this.project);
        dup.projectStats.clearBugCounts();
        dup.errorList.addAll(this.errorList);
        dup.missingClassSet.addAll(this.missingClassSet);
        dup.summaryHTML = this.summaryHTML;
        dup.classFeatureSetMap.putAll(this.classFeatureSetMap);
        dup.sequence = this.sequence;
        dup.analysisVersion = this.analysisVersion;
        dup.analysisTimestamp = this.analysisTimestamp;
        dup.timestamp = this.timestamp;
        dup.releaseName = this.releaseName;
        for (AppVersion appVersion : this.appVersionList) {
            dup.appVersionList.add((AppVersion)appVersion.clone());
        }
        return dup;
    }

    public void clearBugInstances() {
        this.bugSet.clear();
        this.invalidateHashes();
    }

    @Override
    public void clearMissingClasses() {
        this.missingClassSet.clear();
    }

    @Override
    public String getReleaseName() {
        if (this.releaseName == null) {
            return "";
        }
        return this.releaseName;
    }

    @Override
    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    @Override
    public Iterator<AppVersion> appVersionIterator() {
        return this.appVersionList.iterator();
    }

    @Override
    public void addAppVersion(AppVersion appVersion) {
        this.appVersionList.add(appVersion);
    }

    @Override
    public void clearAppVersions() {
        this.appVersionList.clear();
        this.sequence = 0L;
    }

    public void trimAppVersions(long numberToRetain) {
        while ((long)this.appVersionList.size() > numberToRetain) {
            this.appVersionList.remove(this.appVersionList.size() - 1);
        }
        this.sequence = this.appVersionList.size();
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public ClassFeatureSet getClassFeatureSet(String className) {
        return this.classFeatureSetMap.get(className);
    }

    @Override
    public void setClassFeatureSet(ClassFeatureSet classFeatureSet) {
        this.classFeatureSetMap.put(classFeatureSet.getClassName(), classFeatureSet);
    }

    public Iterator<ClassFeatureSet> classFeatureSetIterator() {
        return this.classFeatureSetMap.values().iterator();
    }

    @Override
    public void clearClassFeatures() {
        this.classFeatureSetMap.clear();
    }

    @Override
    public void setWithMessages(boolean withMessages) {
        this.withMessages = withMessages;
    }

    @Override
    public boolean getWithMessages() {
        return this.withMessages;
    }

    @Override
    public AppVersion getAppVersionFromSequenceNumber(long target) {
        for (AppVersion av : this.appVersionList) {
            if (av.getSequenceNumber() != target) continue;
            return av;
        }
        if (target == this.getSequenceNumber()) {
            return this.getCurrentAppVersion();
        }
        return null;
    }

    @Override
    public BugInstance findBug(String instanceHash, String bugType, int lineNumber) {
        for (BugInstance bug : this.bugSet) {
            if (!bug.getInstanceHash().equals(instanceHash) || !bug.getBugPattern().getType().equals(bugType) || bug.getPrimarySourceLineAnnotation().getStartLine() != lineNumber) continue;
            return bug;
        }
        return null;
    }

    @Override
    public void setAnalysisVersion(String version) {
        this.analysisVersion = version;
    }

    public String getAnalysisVersion() {
        return this.analysisVersion;
    }

    public InputStream progessMonitoredInputStream(File f, String msg) throws IOException {
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File " + f + " is too big at " + length + " bytes");
        }
        FileInputStream in = new FileInputStream(f);
        return this.wrapGzip(this.progressMonitoredInputStream(in, (int)length, msg), f);
    }

    public InputStream progessMonitoredInputStream(URLConnection c, String msg) throws IOException {
        InputStream in = c.getInputStream();
        int length = c.getContentLength();
        return this.wrapGzip(this.progressMonitoredInputStream(in, length, msg), c.getURL());
    }

    public InputStream progressMonitoredInputStream(InputStream in, int length, String msg) {
        if (GraphicsEnvironment.isHeadless()) {
            return in;
        }
        IGuiCallback guiCallback = this.project.getGuiCallback();
        return guiCallback.getProgressMonitorInputStream(in, length, msg);
    }

    public InputStream wrapGzip(InputStream in, Object source) {
        try {
            URL u;
            File f;
            if (source instanceof File ? (f = (File)source).getName().endsWith(".gz") : source instanceof URL && (u = (URL)source).getPath().endsWith(".gz")) {
                return new GZIPInputStream(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return in;
    }

    public void clearCloud() {
        Cloud oldCloud = this.cloud;
        IGuiCallback callback = this.project.getGuiCallback();
        if (oldCloud != null) {
            callback.unregisterCloud(this.project, this, oldCloud);
            oldCloud.shutdown();
        }
        this.cloud = null;
    }

    @Override
    @Nonnull
    public Cloud reinitializeCloud() {
        Cloud oldCloud = this.cloud;
        IGuiCallback callback = this.project.getGuiCallback();
        if (oldCloud != null) {
            callback.unregisterCloud(this.project, this, oldCloud);
            oldCloud.shutdown();
        }
        this.cloud = null;
        Cloud newCloud = this.getCloud();
        assert (newCloud == this.cloud);
        assert (this.cloud != null);
        assert (this.cloud.isInitialized());
        if (this.bugsPopulated) {
            this.cloud.bugsPopulated();
            this.cloud.initiateCommunication();
        }
        return this.cloud;
    }

    @Override
    public void setXmlCloudDetails(Map<String, String> map) {
        this.xmlCloudDetails = map;
    }

    @Override
    public Map<String, String> getXmlCloudDetails() {
        return this.xmlCloudDetails;
    }

    @Override
    public void setMinimalXML(boolean minimalXML) {
        this.minimalXML = minimalXML;
    }

    public void setDoNotUseCloud(boolean b) {
        this.shouldNotUsePlugin = b;
    }

    @Override
    public void bugsPopulated() {
        this.bugsPopulated = true;
    }

    public static class MultiversionBugInstanceComparator
    extends BugInstanceComparator {
        public static final MultiversionBugInstanceComparator instance = new MultiversionBugInstanceComparator();

        private MultiversionBugInstanceComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            int result = super.compare(lhs, rhs);
            if (result != 0) {
                return result;
            }
            long diff = lhs.getFirstVersion() - rhs.getFirstVersion();
            if (diff == 0L) {
                diff = lhs.getLastVersion() - rhs.getLastVersion();
            }
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class BugInstanceComparator
    implements Comparator<BugInstance> {
        public static final BugInstanceComparator instance = new BugInstanceComparator();

        private BugInstanceComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            ClassAnnotation lca = lhs.getPrimaryClass();
            ClassAnnotation rca = rhs.getPrimaryClass();
            if (lca == null || rca == null) {
                throw new IllegalStateException("null class annotation: " + lca + "," + rca);
            }
            int cmp = lca.getClassName().compareTo(rca.getClassName());
            if (cmp != 0) {
                return cmp;
            }
            return lhs.compareTo(rhs);
        }
    }

    private static final class BoundedLinkedHashSet
    extends LinkedHashSet<AnalysisError> {
        private BoundedLinkedHashSet() {
        }

        @Override
        public boolean add(AnalysisError a) {
            if (this.size() > 1000) {
                return false;
            }
            return super.add(a);
        }
    }
}

