/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.xml.ASMContentHandler;
import org.objectweb.asm.xml.SAXClassAdapter;

public class SAXAdapterTest
extends AbstractTest {
    public static TestSuite suite() throws Exception {
        return new SAXAdapterTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        ClassWriter cw = new ClassWriter(0);
        SAXTransformerFactory saxtf = (SAXTransformerFactory)TransformerFactory.newInstance();
        TransformerHandler handler = saxtf.newTransformerHandler();
        handler.setResult(new SAXResult(new ASMContentHandler(cw)));
        handler.startDocument();
        cr.accept(new SAXClassAdapter(handler, false), 0);
        handler.endDocument();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(cw.toByteArray());
        ClassWriter cw2 = new ClassWriter(0);
        cr.accept(cw2, new Attribute[]{new Attribute("Comment"){

            protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
                return null;
            }
        }, new Attribute("CodeComment"){

            protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
                return null;
            }
        }}, 0);
        this.assertEquals(new ClassReader(cw2.toByteArray()), new ClassReader(bos.toByteArray()));
    }
}

