/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.util.CheckSignatureAdapter;

public class CheckSignatureAdapterTest
extends AbstractTest {
    public static TestSuite suite() throws Exception {
        return new CheckSignatureAdapterTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        cr.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (signature != null) {
                    SignatureReader sr = new SignatureReader(signature);
                    SignatureWriter sw = new SignatureWriter();
                    sr.accept(new CheckSignatureAdapter(0, sw));
                    CheckSignatureAdapterTest.assertEquals((String)signature, (String)sw.toString());
                }
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if (signature != null) {
                    SignatureReader sr = new SignatureReader(signature);
                    SignatureWriter sw = new SignatureWriter();
                    sr.acceptType(new CheckSignatureAdapter(2, sw));
                    CheckSignatureAdapterTest.assertEquals((String)signature, (String)sw.toString());
                }
                return null;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (signature != null) {
                    SignatureReader sr = new SignatureReader(signature);
                    SignatureWriter sw = new SignatureWriter();
                    sr.accept(new CheckSignatureAdapter(1, sw));
                    CheckSignatureAdapterTest.assertEquals((String)signature, (String)sw.toString());
                }
                return null;
            }
        }, 0);
    }
}

