/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.util.CheckMethodAdapter;

public final class CheckModuleAdapter
extends ModuleVisitor {
    private boolean end;

    public CheckModuleAdapter(ModuleVisitor mv) {
        super(393216, mv);
    }

    public void visitRequire(String module, int access) {
        this.checkEnd();
        if (module == null) {
            throw new IllegalArgumentException("require cannot be null");
        }
        super.visitRequire(module, access);
    }

    public void visitExport(String packaze, String ... modules) {
        this.checkEnd();
        if (packaze == null) {
            throw new IllegalArgumentException("require cannot be null");
        }
        if (modules != null) {
            for (int i = 0; i < modules.length; ++i) {
                if (modules[i] != null) continue;
                throw new IllegalArgumentException("to at index " + i + " cannot be null");
            }
        }
        super.visitExport(packaze, modules);
    }

    public void visitUse(String service) {
        this.checkEnd();
        CheckMethodAdapter.checkInternalName(service, "service");
        super.visitUse(service);
    }

    public void visitProvide(String service, String impl) {
        this.checkEnd();
        CheckMethodAdapter.checkInternalName(service, "service");
        CheckMethodAdapter.checkInternalName(impl, "impl");
        super.visitProvide(service, impl);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        super.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

