/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class ModuleNode
extends ModuleVisitor {
    private int requireCount;
    public String[] requires;
    public int[] requireAccess;
    private int exportCount;
    public String[] exports;
    public String[][] exportTos;
    private int useCount;
    public String[] uses;
    private int provideCount;
    public String[] provides;
    public String[] provideWiths;

    public ModuleNode() {
        super(393216);
    }

    public ModuleNode(int api, String[] requires, int[] requireAccess, String[] exports, String[][] exportTos, String[] uses, String[] provides, String[] provideWiths) {
        super(393216);
        this.requires = requires;
        this.requireCount = requires.length;
        this.requireAccess = requireAccess;
        this.exports = exports;
        this.exportCount = exports.length;
        this.exportTos = exportTos;
        this.uses = uses;
        this.useCount = uses.length;
        this.provides = provides;
        this.provideCount = provides.length;
        this.provideWiths = provideWiths;
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
    }

    private static String[] copyOf(String[] array, int newSize) {
        String[] newArray = new String[newSize];
        System.arraycopy(array, 0, newArray, 0, Math.min(newSize, array.length));
        return newArray;
    }

    private static String[][] copyOf(String[][] array, int newSize) {
        String[][] newArray = new String[newSize][];
        System.arraycopy(array, 0, newArray, 0, Math.min(newSize, array.length));
        return newArray;
    }

    private static int[] copyOf(int[] array, int newSize) {
        int[] newArray = new int[newSize];
        System.arraycopy(array, 0, newArray, 0, Math.min(newSize, array.length));
        return newArray;
    }

    private static String[] trim(String[] array, int size) {
        return array.length == size ? array : ModuleNode.copyOf(array, size);
    }

    private static String[][] trim(String[][] array, int size) {
        return array.length == size ? array : ModuleNode.copyOf(array, size);
    }

    private static int[] trim(int[] array, int size) {
        return array.length == size ? array : ModuleNode.copyOf(array, size);
    }

    public void visitRequire(String module, int access) {
        if (this.requires == null) {
            this.requires = new String[8];
            this.requireAccess = new int[8];
        }
        if (this.requireCount == this.requires.length) {
            this.requires = ModuleNode.copyOf(this.requires, this.requireCount << 1);
            this.requireAccess = ModuleNode.copyOf(this.requireAccess, this.requireCount << 1);
        }
        this.requires[this.requireCount] = module;
        this.requireAccess[this.requireCount++] = access;
    }

    public void visitExport(String packaze, String ... modules) {
        if (this.exports == null) {
            this.exports = new String[8];
            this.exportTos = new String[8][];
        }
        if (this.exportCount == this.exports.length) {
            this.exports = ModuleNode.copyOf(this.exports, this.exportCount << 1);
            this.exportTos = ModuleNode.copyOf(this.exportTos, this.exportCount << 1);
        }
        this.exports[this.exportCount] = packaze;
        this.exportTos[this.exportCount++] = modules;
    }

    public void visitUse(String service) {
        if (this.uses == null) {
            this.uses = new String[8];
        }
        if (this.useCount == this.uses.length) {
            this.uses = ModuleNode.copyOf(this.uses, this.useCount << 1);
        }
        this.uses[this.useCount++] = service;
    }

    public void visitProvide(String service, String impl) {
        if (this.provides == null) {
            this.provides = new String[8];
            this.provideWiths = new String[8];
        }
        if (this.provideCount == this.provides.length) {
            this.provides = ModuleNode.copyOf(this.provides, this.provideCount << 1);
            this.provideWiths = ModuleNode.copyOf(this.provideWiths, this.provideCount << 1);
        }
        this.provides[this.provideCount] = service;
        this.provideWiths[this.provideCount++] = impl;
    }

    public void visitEnd() {
        if (this.requires != null) {
            this.requires = ModuleNode.trim(this.requires, this.requireCount);
            this.requireAccess = ModuleNode.trim(this.requireAccess, this.requireCount);
        }
        if (this.exports != null) {
            this.exports = ModuleNode.trim(this.exports, this.exportCount);
            this.exportTos = ModuleNode.trim(this.exportTos, this.exportCount);
        }
        if (this.uses != null) {
            this.uses = ModuleNode.trim(this.uses, this.useCount);
        }
        if (this.provides != null) {
            this.provides = ModuleNode.trim(this.provides, this.provideCount);
            this.provideWiths = ModuleNode.trim(this.provideWiths, this.provideCount);
        }
    }

    public void accept(ClassVisitor cv) {
        int i;
        ModuleVisitor mv = cv.visitModule();
        if (mv == null) {
            return;
        }
        if (this.requires != null) {
            for (i = 0; i < this.requires.length; ++i) {
                mv.visitRequire(this.requires[i], this.requireAccess[i]);
            }
        }
        if (this.exports != null) {
            for (i = 0; i < this.exports.length; ++i) {
                mv.visitExport(this.exports[i], this.exportTos[i]);
            }
        }
        if (this.uses != null) {
            for (String use : this.uses) {
                mv.visitUse(use);
            }
        }
        if (this.provides != null) {
            for (int i2 = 0; i2 < this.provides.length; ++i2) {
                mv.visitExport(this.provides[i2], this.provideWiths[i2]);
            }
        }
    }
}

