/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.IOException;
import java.io.Serializable;
import junit.framework.TestCase;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.commons.SerialVersionClass;
import org.objectweb.asm.commons.SerialVersionEmptyInterface;
import org.objectweb.asm.commons.SerialVersionEnum;
import org.objectweb.asm.commons.SerialVersionInterface;
import org.objectweb.asm.commons.SerialVersionUIDAdder;

public class SerialVersionUIDAdderUnitTest
extends TestCase
implements Serializable {
    static {
        System.setIn(System.in);
    }

    private long computeSerialVersionUID(String className) throws IOException {
        final long[] svuid = new long[1];
        SerialVersionUIDAdder cv = new SerialVersionUIDAdder(327680, null){

            protected long computeSVUID() throws IOException {
                svuid[0] = super.computeSVUID();
                return svuid[0];
            }
        };
        new ClassReader(className).accept(cv, 0);
        return svuid[0];
    }

    public void testClass() throws Throwable {
        long UID = this.computeSerialVersionUID(SerialVersionClass.class.getName());
        SerialVersionUIDAdderUnitTest.assertEquals((long)4737241769335595888L, (long)UID);
    }

    public void testInterface() throws Throwable {
        long UID = this.computeSerialVersionUID(SerialVersionInterface.class.getName());
        SerialVersionUIDAdderUnitTest.assertEquals((long)-1271936742430161320L, (long)UID);
    }

    public void testEmptyInterface() throws Throwable {
        long UID = this.computeSerialVersionUID(SerialVersionEmptyInterface.class.getName());
        SerialVersionUIDAdderUnitTest.assertEquals((long)8675733916152748550L, (long)UID);
    }

    public void testEnum() throws Throwable {
        long UID = this.computeSerialVersionUID(SerialVersionEnum.class.getName());
        SerialVersionUIDAdderUnitTest.assertEquals((long)0L, (long)UID);
    }
}

