/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.LocalVariablesSorter;

public class LocalVariablesSorterTest
extends AbstractTest {
    private static final TestClassLoader LOADER = new TestClassLoader();

    public static TestSuite suite() throws Exception {
        return new LocalVariablesSorterTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        ClassWriter cw = new ClassWriter(0);
        cr.accept(new ClassVisitor(327680, cw){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new LocalVariablesSorter(access, desc, super.visitMethod(access, name, desc, signature, exceptions));
            }
        }, 8);
        byte[] b = cw.toByteArray();
        try {
            LOADER.defineClass(this.n, b);
        }
        catch (ClassFormatError cfe) {
            LocalVariablesSorterTest.fail((String)cfe.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

