/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

public class AdviceAdapterUnitTest
extends AbstractTest {
    private static int n = 0;

    public void test() throws Exception {
        Class<?> c = ((Object)((Object)this)).getClass();
        String name = c.getName();
        AdvisingClassLoader cl = new AdvisingClassLoader(String.valueOf(name) + "$");
        Class<?> cc = cl.loadClass(String.valueOf(name) + "$B");
        Method m = cc.getMethod("run", Integer.TYPE);
        try {
            m.invoke(null, new Integer(0));
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
    }

    public static void enter(String msg) {
        System.err.println(AdviceAdapterUnitTest.off().append("enter ").append(msg).toString());
        ++n;
    }

    public static void exit(String msg) {
        --n;
        System.err.println(AdviceAdapterUnitTest.off().append("<").toString());
    }

    private static StringBuilder off() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            sb.append("  ");
            ++i;
        }
        return sb;
    }

    public static class A {
        final String s;

        public A(String s) {
            this.s = s;
        }

        public A(A a) {
            this.s = a.s;
        }
    }

    static class AdviceClassAdapter
    extends ClassVisitor
    implements Opcodes {
        String cname;

        public AdviceClassAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.cname = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null || (access & 0x500) > 0) {
                return mv;
            }
            return new AdviceAdapter(327680, mv, access, name, desc){

                protected void onMethodEnter() {
                    this.mv.visitLdcInsn(String.valueOf(AdviceClassAdapter.this.cname) + "." + name + desc);
                    this.mv.visitMethodInsn(184, "org/objectweb/asm/commons/AdviceAdapterUnitTest", "enter", "(Ljava/lang/String;)V", false);
                }

                protected void onMethodExit(int opcode) {
                    this.mv.visitLdcInsn(String.valueOf(AdviceClassAdapter.this.cname) + "." + name + desc);
                    this.mv.visitMethodInsn(184, "org/objectweb/asm/commons/AdviceAdapterUnitTest", "exit", "(Ljava/lang/String;)V", false);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdvisingClassLoader
    extends ClassLoader {
        private String prefix;

        public AdvisingClassLoader(String prefix) throws IOException {
            this.prefix = prefix;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith(this.prefix)) {
                try {
                    ClassWriter cw = new ClassWriter(1);
                    ClassReader cr = new ClassReader(this.getClass().getResourceAsStream("/" + name.replace('.', '/') + ".class"));
                    cr.accept(new AdviceClassAdapter(cw), 8);
                    byte[] bytecode = cw.toByteArray();
                    return super.defineClass(name, bytecode, 0, bytecode.length);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Load error: " + ex.toString(), ex);
                }
            }
            return super.loadClass(name);
        }
    }

    public static class B
    extends A {
        private static A aa;

        public B() {
            super(new B(""));
            this.test(this);
        }

        public B(A a) {
            super(a);
            this.test(this);
        }

        public B(String s) {
            super(s == null ? new A("") : new A(s));
            this.test(this);
        }

        public B(String s, A a) {
            this(s == null ? (aa = new A(s)) : a);
            A aa = new A("");
            this.test(aa);
        }

        public B(String s, String s1) {
            super(s != null ? new A(B.getA((String)s1).s) : new A(s));
            this.test(this);
        }

        private void test(Object b) {
        }

        private static A getA(String s) {
            return new A(s);
        }

        public static void run(int n) {
            new B();
            new B(new A(""));
            new B(new B());
            new B("", new A(""));
            new B("", "");
        }
    }
}

