/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import junit.framework.TestCase;
import org.objectweb.asm.MethodVisitor;

public class BackwardCompatibilityUnitTest
extends TestCase {
    public void testBackwardCompatibilityOk() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor4 mv = new MethodVisitor4((MethodVisitor)cmv);
        mv.visitMethodInsn(0, "C", "m", "()V", false);
        BackwardCompatibilityUnitTest.assertEquals((String)"m", (String)cmv.name);
    }

    public void testBackwardCompatibilityFail() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor4 mv = new MethodVisitor4((MethodVisitor)cmv);
        try {
            mv.visitMethodInsn(0, "C", "m", "()V", true);
            BackwardCompatibilityUnitTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testBackwardCompatibilityOverride() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor4Override mv = new MethodVisitor4Override((MethodVisitor)cmv);
        mv.visitMethodInsn(0, "C", "m", "()V", false);
        BackwardCompatibilityUnitTest.assertEquals((String)"mv4", (String)cmv.name);
    }

    public void testBackwardCompatibilityOverrideFail() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor4Override mv = new MethodVisitor4Override((MethodVisitor)cmv);
        try {
            mv.visitMethodInsn(0, "C", "m", "()V", true);
            BackwardCompatibilityUnitTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNewMethod() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor5 mv = new MethodVisitor5((MethodVisitor)cmv);
        mv.visitMethodInsn(0, "C", "m", "()V", false);
        BackwardCompatibilityUnitTest.assertEquals((String)"m", (String)cmv.name);
    }

    public void testNewMethodOverride() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor5Override mv = new MethodVisitor5Override((MethodVisitor)cmv);
        ((MethodVisitor)mv).visitMethodInsn(0, "C", "m", "()V", false);
        BackwardCompatibilityUnitTest.assertEquals((String)"mv5", (String)cmv.name);
    }

    public void testBackwardCompatibilityMixedChain() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor mv = new MethodVisitor4((MethodVisitor)cmv);
        mv = new MethodVisitor4Override(mv);
        mv = new MethodVisitor5(mv);
        mv = new MethodVisitor5Override(mv);
        mv.visitMethodInsn(0, "C", "m", "()V", false);
        BackwardCompatibilityUnitTest.assertEquals((String)"mv5v4", (String)cmv.name);
    }

    public void testBackwardCompatibilityMixedChain2() {
        CheckMethodVisitor cmv = new CheckMethodVisitor();
        MethodVisitor mv = new MethodVisitor5((MethodVisitor)cmv);
        mv = new MethodVisitor5Override(mv);
        mv = new MethodVisitor4(mv);
        mv = new MethodVisitor4Override(mv);
        mv.visitMethodInsn(0, "C", "m", "()V", false);
        BackwardCompatibilityUnitTest.assertEquals((String)"mv4v5", (String)cmv.name);
    }

    class CheckMethodVisitor
    extends MethodVisitor {
        public String name;

        CheckMethodVisitor() {
            super(327680);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.name = name;
        }
    }

    class MethodVisitor4
    extends MethodVisitor {
        MethodVisitor4(MethodVisitor mv) {
            super(262144, mv);
        }
    }

    class MethodVisitor4Override
    extends MethodVisitor {
        MethodVisitor4Override(MethodVisitor mv) {
            super(262144, mv);
        }

        @Deprecated
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, String.valueOf(name) + "v4", desc);
        }
    }

    class MethodVisitor5
    extends MethodVisitor {
        MethodVisitor5(MethodVisitor mv) {
            super(327680, mv);
        }
    }

    class MethodVisitor5Override
    extends MethodVisitor {
        MethodVisitor5Override(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, String.valueOf(name) + "v5", desc, itf);
        }
    }
}

