/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class ASMMemTest {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("java ASMMemTest <jar-file> <number-of-classes>");
            System.exit(1);
        }
        Runtime runtime = Runtime.getRuntime();
        ASMMemTest.memDown(runtime);
        System.out.println("Initial memory load: ".concat(ASMMemTest.memFormat(ASMMemTest.getUsedMem(runtime))));
        LinkedList<byte[]> fileData = new LinkedList<byte[]>();
        int limit = Integer.parseInt(args[1]);
        try {
            long totalSize = 0L;
            JarInputStream jar = new JarInputStream(new FileInputStream(args[0]));
            JarEntry entry = jar.getNextJarEntry();
            while (fileData.size() < limit && entry != null) {
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    if (entry.getSize() != -1L) {
                        int len = (int)entry.getSize();
                        byte[] data = new byte[len];
                        int l = jar.read(data);
                        assert (l == len);
                        fileData.add(data);
                        totalSize += (long)data.length;
                    } else {
                        System.err.println("No jar-entry size given... Unimplemented, jar file not supported");
                    }
                }
                entry = jar.getNextJarEntry();
            }
            System.out.println(String.valueOf(ASMMemTest.memFormat(totalSize)) + " class data, ~" + ASMMemTest.memFormat(totalSize / (long)limit) + " per class.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<ClassNode> result = new ArrayList<ClassNode>(fileData.size());
        int i = 0;
        while (i < 10) {
            System.out.println("\n> Run ".concat(Integer.toString(i + 1)));
            Iterator files = fileData.iterator();
            result.clear();
            ASMMemTest.memDown(runtime);
            long startmem = ASMMemTest.getUsedMem(runtime);
            System.out.println("Empty memory load: ".concat(ASMMemTest.memFormat(startmem)));
            long time = -System.currentTimeMillis();
            while (files.hasNext()) {
                byte[] data = (byte[])files.next();
                ClassReader reader = new ClassReader(data);
                ClassNode clazz = new ClassNode();
                reader.accept(clazz, 0);
                result.add(clazz);
            }
            ASMMemTest.memDown(runtime);
            System.out.println("Time: ".concat(ASMMemTest.timeFormat(time += System.currentTimeMillis())));
            System.out.println("Final memory load: ".concat(ASMMemTest.memFormat(ASMMemTest.getUsedMem(runtime))));
            System.out.println("ASM memory load: ".concat(ASMMemTest.memFormat(ASMMemTest.getUsedMem(runtime) - startmem)));
            int j = 0;
            while (j < limit) {
                ClassNode clazz = (ClassNode)result.get(j);
                List<MethodNode> l = clazz.methods;
                int k = 0;
                int lim = l.size();
                while (k < lim) {
                    MethodNode m = l.get(k);
                    InsnList insn = m.instructions;
                    if (insn != null) {
                        insn.clear();
                    }
                    ++k;
                }
                ++j;
            }
            ASMMemTest.memDown(runtime);
            System.out.println("ASM memory load (removed method code): ".concat(ASMMemTest.memFormat(ASMMemTest.getUsedMem(runtime) - startmem)));
            ++i;
        }
    }

    public static final long getUsedMem(Runtime r) {
        return r.totalMemory() - r.freeMemory();
    }

    public static final String timeFormat(long time) {
        int min = (int)(time / 60000L);
        int sec = (int)(time / 1000L % 60L);
        int msec = (int)(time % 1000L);
        StringBuilder sbuf = new StringBuilder(30);
        if (min > 0) {
            sbuf.append(min);
            sbuf.append("min ");
        }
        if (sec > 0 || min > 0) {
            sbuf.append(sec);
            sbuf.append("s ");
        }
        if (msec > 0 || sec > 0 || min > 0) {
            sbuf.append(msec);
            sbuf.append("ms ");
        }
        sbuf.append('(');
        sbuf.append(time);
        sbuf.append("ms)");
        return sbuf.toString();
    }

    public static final String memFormat(long mem) {
        int gb = (int)(mem >> 30 & 0x3FFL);
        int mb = (int)(mem >> 20 & 0x3FFL);
        int kb = (int)(mem >> 10 & 0x3FFL);
        int bytes = (int)(mem & 0x3FFL);
        StringBuilder sbuf = new StringBuilder(30);
        if (gb > 0) {
            sbuf.append(gb);
            sbuf.append("GB ");
        }
        if (mb > 0 || gb > 0) {
            sbuf.append(mb);
            sbuf.append("MB ");
        }
        if (kb > 0 || mb > 0 || gb > 0) {
            sbuf.append(kb);
            sbuf.append("KB ");
        }
        if (bytes > 0 || kb > 0 || mb > 0 || gb > 0) {
            sbuf.append(bytes);
            sbuf.append("bytes ");
        }
        sbuf.append('(');
        sbuf.append(mem);
        sbuf.append("bytes)");
        return sbuf.toString();
    }

    public static final void memDown(Runtime r) {
        long oldmem;
        do {
            oldmem = ASMMemTest.getUsedMem(r);
            int i = 0;
            while (i < 10) {
                System.gc();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        } while (ASMMemTest.getUsedMem(r) < oldmem);
    }
}

