/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import junit.framework.TestCase;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.xml.ASMContentHandler;
import org.objectweb.asm.xml.SAXClassAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ASMContentHandlerUnitTest
extends TestCase
implements Opcodes {
    ASMContentHandler h;
    ClassVisitor cv;
    MethodVisitor mv;

    protected void setUp() throws Exception {
        this.h = new ASMContentHandler(new ClassVisitor(327680){
            AnnotationVisitor av;
            {
                this.av = new AnnotationVisitor(327680){

                    public AnnotationVisitor visitAnnotation(String name, String desc) {
                        return this;
                    }

                    public AnnotationVisitor visitArray(String name) {
                        return this;
                    }
                };
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return this.av;
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                return this.av;
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return new FieldVisitor(327680){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return av;
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return av;
                    }
                };
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680){

                    public AnnotationVisitor visitAnnotationDefault() {
                        return av;
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return av;
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return av;
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                        return av;
                    }

                    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return av;
                    }

                    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                        return av;
                    }

                    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
                        return av;
                    }
                };
            }
        });
        this.cv = new SAXClassAdapter(this.h, true);
        this.cv.visit(49, 1, "C", null, "java/lang/Object", null);
    }

    protected void methodSetUp() {
        this.mv = this.cv.visitMethod(0, "<init>", "()V", null, null);
        this.mv.visitCode();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
    }

    public void testInvalidOpcode() {
        this.methodSetUp();
        AttributesImpl attrs = new AttributesImpl();
        try {
            this.h.startElement("", "opcode", "", attrs);
            this.h.endElement("", "opcode", "");
            ASMContentHandlerUnitTest.fail();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testInvalidValueDescriptor() {
        this.methodSetUp();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", "desc");
        attrs.addAttribute("", "cst", "cst", "", "");
        try {
            this.h.startElement("", "LDC", "", attrs);
            this.h.endElement("", "LDC", "");
            ASMContentHandlerUnitTest.fail();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testInvalidValue() {
        this.methodSetUp();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", "Ljava/lang/String;");
        attrs.addAttribute("", "cst", "cst", "", "\\");
        try {
            this.h.startElement("", "LDC", "", attrs);
            this.h.endElement("", "LDC", "");
            ASMContentHandlerUnitTest.fail();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testEndDocument() {
        this.cv.visitEnd();
        try {
            this.h.endDocument();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

