/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.TestSuite;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.attrs.CodeComment;
import org.objectweb.asm.attrs.Comment;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMifierTest
extends AbstractTest {
    public static final TestClassLoader LOADER = new TestClassLoader();

    public static TestSuite suite() throws Exception {
        return new ASMifierTest().getSuite();
    }

    public void test() throws Exception {
        byte[] generatorClassData;
        ClassReader cr = new ClassReader(this.is);
        if (cr.b.length > 20000) {
            return;
        }
        StringWriter sw = new StringWriter();
        TraceClassVisitor cv = new TraceClassVisitor(null, new ASMifier(), new PrintWriter(sw));
        cr.accept(cv, new Attribute[]{new Comment(), new CodeComment()}, 0);
        String generated = sw.toString();
        try {
            generatorClassData = Compiler.compile(this.n, generated);
        }
        catch (Exception ex) {
            System.err.println(generated);
            System.err.println("------------------");
            throw ex;
        }
        String nd = String.valueOf(this.n) + "Dump";
        if (this.n.indexOf(46) != -1) {
            nd = "asm." + nd;
        }
        Class<?> c = LOADER.defineClass(nd, generatorClassData);
        Method m = c.getMethod("dump", new Class[0]);
        byte[] b = (byte[])m.invoke(null, new Object[0]);
        this.assertEquals(cr, new ClassReader(b));
    }

    public static class Compiler {
        static final IClassLoader CL = new ClassLoaderIClassLoader((ClassLoader)new URLClassLoader(new URL[0]));

        public static byte[] compile(String name, String source) throws Exception {
            Parser p = new Parser(new Scanner(name, (Reader)new StringReader(source)));
            UnitCompiler uc = new UnitCompiler(p.parseCompilationUnit(), CL);
            return uc.compileUnit(DebuggingInformation.ALL)[0].toByteArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestClassLoader
    extends ClassLoader {
        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

