/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.test.cases;

import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.test.cases.Generator;

public class Frames
extends Generator {
    static final int M = 8;
    static final String I1 = "Ljava/io/Serializable;";
    static final String I2 = "Ljava/lang/Comparable;";

    public void generate(String dir) throws IOException {
        byte[] b = this.dump();
        ClassWriter cw = new ClassWriter(0);
        ClassReader cr = new ClassReader(b);
        cr.accept(new RenameAdapter(cw), 8);
        this.generate(dir, "pkg/FrameTable.class", b);
        this.generate(dir, "pkg/FrameMap.class", cw.toByteArray());
    }

    public byte[] dump() {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 33, "pkg/FrameTable", null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(8, "long", "Ljava/lang/Long;", null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "double", "Ljava/lang/Double;", null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "number", "Ljava/lang/Number;", null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "serializable", I1, null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "comparable", I2, null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "longArray", "[Ljava/lang/Long;", null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "intArray", "[I", null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "floatArray", "[F", null, null);
        fv.visitEnd();
        fv = cw.visitField(8, "objectArray", "[Ljava/lang/Object;", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.uninitializedThisType(cw);
        this.uninitializedLocalType(cw);
        this.uninitializedStackType(cw);
        this.nullType(cw);
        this.topType(cw);
        this.arrayTypes(cw);
        this.mergeTypes(cw);
        this.mergeStackTypes(cw);
        this.mergeNullArray(cw);
        this.appendAndChopFrame(cw);
        this.sameLocals1stackItemFrame(cw);
        this.sameLocals1stackItemFrame2(cw);
        this.sameLocals1stackItemFrameExtended(cw);
        this.sameFrameExtended(cw);
        this.deadCode(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void uninitializedThisType(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitTypeInsn(187, "pkg/FrameTable");
        mv.visitInsn(89);
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(154, l1);
        mv.visitInsn(1);
        Label l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitFrame(0, 2, new Object[]{UNINITIALIZED_THIS, INTEGER}, 3, new Object[]{UNINITIALIZED_THIS, l0, l0});
        mv.visitLabel(l1);
        mv.visitTypeInsn(187, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitFrame(0, 2, new Object[]{UNINITIALIZED_THIS, INTEGER}, 4, new Object[]{UNINITIALIZED_THIS, l0, l0, "java/lang/Object"});
        mv.visitLabel(l2);
        mv.visitMethodInsn(183, "pkg/FrameTable", "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitMethodInsn(183, "pkg/FrameTable", "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void uninitializedLocalType(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "uninitializedLocalType", "(Z)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitTypeInsn(187, "java/lang/Long");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(9);
        Label l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitFrame(0, 3, new Object[]{"pkg/FrameTable", INTEGER, l0}, 1, new Object[]{l0});
        mv.visitLabel(l1);
        mv.visitInsn(10);
        mv.visitFrame(0, 3, new Object[]{"pkg/FrameTable", INTEGER, l0}, 2, new Object[]{l0, LONG});
        mv.visitLabel(l2);
        mv.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void uninitializedStackType(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "uninitializedStackType", "(Z)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitTypeInsn(187, "java/lang/Long");
        mv.visitInsn(89);
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(9);
        mv.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V", false);
        Label l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitFrame(0, 1, new Object[]{"pkg/FrameTable"}, 2, new Object[]{l0, l0});
        mv.visitLabel(l1);
        mv.visitInsn(10);
        mv.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V", false);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Long"});
        mv.visitLabel(l2);
        mv.visitVarInsn(58, 2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void nullType(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "nullType", "(Ljava/lang/String;Ljava/lang/String;)V", null, null);
        mv.visitCode();
        mv.visitInsn(1);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitVarInsn(25, 2);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitFrame(0, 3, new Object[]{"pkg/FrameTable", "java/lang/String", NULL}, 2, new Object[]{"pkg/FrameTable", NULL});
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitFrame(0, 3, new Object[]{"pkg/FrameTable", "java/lang/String", NULL}, 3, new Object[]{"pkg/FrameTable", NULL, "java/lang/String"});
        mv.visitLabel(l1);
        mv.visitMethodInsn(182, "pkg/FrameTable", "nullType", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void topType(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "topType", "(ZBCSIFJDLjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 5);
        mv.visitVarInsn(54, 13);
        mv.visitVarInsn(21, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitInsn(177);
        mv.visitFrame(1, 2, new Object[]{TOP, INTEGER}, 0, null);
        mv.visitLabel(l0);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void arrayTypes(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "fullFrame", "(Ljava/lang/String;[[Z[B[C[S[I[F[J[D[Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 11);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 13);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 15);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 17);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(177);
        mv.visitFrame(0, 15, new Object[]{"pkg/FrameTable", "java/lang/String", "[[Z", "[B", "[C", "[S", "[I", "[F", "[J", "[D", "[Ljava/lang/Object;", LONG, LONG, LONG, LONG}, 0, new Object[0]);
        mv.visitLabel(l0);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void mergeTypes(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "mergeTypes", "(Z)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitFieldInsn(178, "pkg/FrameTable", "long", "Ljava/lang/Long;");
        mv.visitVarInsn(58, 2);
        mv.visitFieldInsn(178, "pkg/FrameTable", "number", "Ljava/lang/Number;");
        mv.visitVarInsn(58, 3);
        mv.visitFieldInsn(178, "pkg/FrameTable", "number", "Ljava/lang/Long;");
        mv.visitVarInsn(58, 4);
        mv.visitFieldInsn(178, "pkg/FrameTable", "comparable", I2);
        mv.visitVarInsn(58, 5);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 6);
        mv.visitFieldInsn(178, "pkg/FrameTable", "double", "Ljava/lang/Double;");
        mv.visitVarInsn(58, 7);
        mv.visitInsn(3);
        mv.visitVarInsn(54, 8);
        mv.visitFieldInsn(178, "pkg/FrameTable", "intArray", "[I");
        mv.visitVarInsn(58, 9);
        mv.visitFieldInsn(178, "pkg/FrameTable", "double", "Ljava/lang/Double;");
        mv.visitVarInsn(58, 10);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 11);
        mv.visitFrame(0, 12, new Object[]{"pkg/FrameTable", INTEGER, "java/lang/Number", "java/lang/Number", "java/lang/Number", "java/lang/Object", NULL, "java/lang/Double", TOP, "java/lang/Object", "java/lang/Object", "[Ljava/lang/Object;"}, 0, null);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 11);
        mv.visitInsn(3);
        mv.visitInsn(1);
        mv.visitInsn(83);
        mv.visitFieldInsn(178, "pkg/FrameTable", "double", "Ljava/lang/Double;");
        mv.visitVarInsn(58, 2);
        mv.visitFieldInsn(178, "pkg/FrameTable", "double", "Ljava/lang/Double;");
        mv.visitVarInsn(58, 3);
        mv.visitFieldInsn(178, "pkg/FrameTable", "number", "Ljava/lang/Number;");
        mv.visitVarInsn(58, 4);
        mv.visitFieldInsn(178, "pkg/FrameTable", "serializable", I1);
        mv.visitVarInsn(58, 5);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 6);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 7);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 8);
        mv.visitFieldInsn(178, "pkg/FrameTable", "floatArray", "[F");
        mv.visitVarInsn(58, 9);
        mv.visitFieldInsn(178, "pkg/FrameTable", "intArray", "[I");
        mv.visitVarInsn(58, 10);
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitVarInsn(58, 11);
        mv.visitJumpInsn(167, l0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void mergeStackTypes(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "mergeStackTypes", "(Z)V", null, null);
        mv.visitCode();
        mv.visitInsn(3);
        mv.visitInsn(4);
        mv.visitVarInsn(21, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitInsn(3);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitFrame(0, 1, new Object[]{"pkg/FrameTable"}, 2, new Object[]{INTEGER, INTEGER});
        mv.visitLabel(l0);
        mv.visitInsn(89);
        mv.visitFrame(0, 1, new Object[]{"pkg/FrameTable"}, 3, new Object[]{INTEGER, INTEGER, INTEGER});
        mv.visitLabel(l1);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void mergeNullArray(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "mergeNullArray", "(Z)I", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(21, 1);
        Label l2 = new Label();
        mv.visitJumpInsn(153, l2);
        mv.visitFieldInsn(178, "pkg/FrameTable", "longArray", "[Ljava/lang/Long;");
        mv.visitVarInsn(58, 2);
        mv.visitFrame(1, 1, new Object[]{"[Ljava/lang/Long;"}, 0, null);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 2);
        Label l3 = new Label();
        mv.visitJumpInsn(198, l3);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(190);
        Label l4 = new Label();
        mv.visitJumpInsn(154, l4);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitLabel(l3);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 3);
        Label l5 = new Label();
        mv.visitJumpInsn(167, l5);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitLabel(l4);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(21, 1);
        mv.visitJumpInsn(154, l5);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 3);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitLabel(l5);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitLabel(l1);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void appendAndChopFrame(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "appendAndChopFrame", "(I)V", null, null);
        mv.visitCode();
        mv.visitInsn(3);
        mv.visitVarInsn(54, 2);
        mv.visitFrame(1, 1, new Object[]{INTEGER}, 0, null);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(162, l1);
        mv.visitIincInsn(2, 1);
        mv.visitJumpInsn(167, l0);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitLabel(l1);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void sameLocals1stackItemFrame(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "sameLocals1stackItemFrame", "()I", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        mv.visitTryCatchBlock(l0, l1, l0, null);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitLabel(l0);
        mv.visitVarInsn(58, 1);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void sameLocals1stackItemFrame2(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "sameLocals1stackItemFrame2", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Exception");
        Label l3 = new Label();
        mv.visitTryCatchBlock(l0, l1, l3, null);
        Label l4 = new Label();
        mv.visitTryCatchBlock(l2, l4, l3, null);
        Label l5 = new Label();
        mv.visitTryCatchBlock(l3, l5, l3, null);
        mv.visitLabel(l0);
        mv.visitTypeInsn(187, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitLabel(l1);
        Label l6 = new Label();
        mv.visitJumpInsn(167, l6);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
        mv.visitLabel(l2);
        mv.visitVarInsn(58, 2);
        mv.visitLabel(l4);
        mv.visitJumpInsn(167, l6);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitLabel(l3);
        mv.visitVarInsn(58, 3);
        mv.visitLabel(l5);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(191);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitLabel(l6);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void sameLocals1stackItemFrameExtended(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "sameLocals1stackItemFrameExtended", "()I", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, null);
        Label l3 = new Label();
        mv.visitTryCatchBlock(l2, l3, l2, null);
        mv.visitLabel(l0);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 1);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 3);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 5);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 7);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 9);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 11);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 13);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 15);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 17);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 19);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 21);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 23);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 25);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitLabel(l2);
        mv.visitVarInsn(58, 27);
        mv.visitLabel(l3);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void sameFrameExtended(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "sameFrameExtended", "(Z)V", null, null);
        mv.visitCode();
        mv.visitFrame(3, 0, null, 0, null);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 2);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 4);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 6);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 8);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 10);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 12);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 14);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 16);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 18);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 20);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 22);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 24);
        mv.visitLdcInsn(new Long(11L));
        mv.visitVarInsn(55, 26);
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(177);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitLabel(l1);
        mv.visitJumpInsn(167, l0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void deadCode(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "deadCode", "(Z)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        mv.visitTryCatchBlock(l0, l1, l1, "java/lang/Exception");
        mv.visitTryCatchBlock(l2, l3, l3, "java/lang/Exception");
        mv.visitJumpInsn(167, l2);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitLabel(l0);
        mv.visitInsn(177);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
        mv.visitLabel(l1);
        mv.visitVarInsn(58, 2);
        mv.visitInsn(177);
        mv.visitFrame(0, 0, new Object[]{"pkg/FrameTable", INTEGER}, 0, null);
        mv.visitLabel(l2);
        mv.visitInsn(177);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
        mv.visitLabel(l3);
        mv.visitVarInsn(58, 2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static class RenameAdapter
    extends ClassVisitor {
        public RenameAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(49, access, "pkg/FrameMap", signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    Object[] clocal = new Object[local.length];
                    int i = 0;
                    while (i < clocal.length) {
                        clocal[i] = local[i];
                        if ("pkg/FrameTable".equals(clocal[i])) {
                            clocal[i] = "pkg/FrameMap";
                        }
                        ++i;
                    }
                    Object[] cstack = new Object[stack.length];
                    int i2 = 0;
                    while (i2 < cstack.length) {
                        cstack[i2] = stack[i2];
                        if ("pkg/FrameTable".equals(cstack[i2])) {
                            cstack[i2] = "pkg/FrameMap";
                        }
                        ++i2;
                    }
                    super.visitFrame(type, nLocal, clocal, nStack, cstack);
                }

                public void visitTypeInsn(int opcode, String desc) {
                    if (desc.equals("pkg/FrameTable")) {
                        super.visitTypeInsn(opcode, "pkg/FrameMap");
                    } else {
                        super.visitTypeInsn(opcode, desc);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (owner.equals("pkg/FrameTable")) {
                        super.visitMethodInsn(opcode, "pkg/FrameMap", name, desc, itf);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                }
            };
        }
    }
}

