/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.TestCase;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class TypeUnitTest
extends TestCase
implements Opcodes {
    public void testConstants() {
        TypeUnitTest.assertEquals((Object)Type.INT_TYPE, (Object)Type.getType(Integer.TYPE));
        TypeUnitTest.assertEquals((Object)Type.VOID_TYPE, (Object)Type.getType(Void.TYPE));
        TypeUnitTest.assertEquals((Object)Type.BOOLEAN_TYPE, (Object)Type.getType(Boolean.TYPE));
        TypeUnitTest.assertEquals((Object)Type.BYTE_TYPE, (Object)Type.getType(Byte.TYPE));
        TypeUnitTest.assertEquals((Object)Type.CHAR_TYPE, (Object)Type.getType(Character.TYPE));
        TypeUnitTest.assertEquals((Object)Type.SHORT_TYPE, (Object)Type.getType(Short.TYPE));
        TypeUnitTest.assertEquals((Object)Type.DOUBLE_TYPE, (Object)Type.getType(Double.TYPE));
        TypeUnitTest.assertEquals((Object)Type.FLOAT_TYPE, (Object)Type.getType(Float.TYPE));
        TypeUnitTest.assertEquals((Object)Type.LONG_TYPE, (Object)Type.getType(Long.TYPE));
    }

    public void testInternalName() {
        String s1 = Type.getType(TypeUnitTest.class).getInternalName();
        String s2 = Type.getInternalName(TypeUnitTest.class);
        TypeUnitTest.assertEquals((String)s1, (String)s2);
    }

    public void testConstructorDescriptor() {
        int i = 0;
        while (i < String.class.getConstructors().length) {
            Constructor<?> c = String.class.getConstructors()[i];
            Type.getConstructorDescriptor(c);
            ++i;
        }
    }

    public void testMethodDescriptor() {
        int i = 0;
        while (i < Arrays.class.getMethods().length) {
            Method m = Arrays.class.getMethods()[i];
            Type[] args = Type.getArgumentTypes(m);
            Type r = Type.getReturnType(m);
            String d1 = Type.getMethodDescriptor(r, args);
            String d2 = Type.getMethodDescriptor(m);
            TypeUnitTest.assertEquals((String)d1, (String)d2);
            ++i;
        }
    }

    public void testGetOpcode() {
        Type object = Type.getType("Ljava/lang/Object;");
        TypeUnitTest.assertEquals((int)51, (int)Type.BOOLEAN_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)51, (int)Type.BYTE_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)52, (int)Type.CHAR_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)53, (int)Type.SHORT_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)46, (int)Type.INT_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)48, (int)Type.FLOAT_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)47, (int)Type.LONG_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)49, (int)Type.DOUBLE_TYPE.getOpcode(46));
        TypeUnitTest.assertEquals((int)50, (int)object.getOpcode(46));
        TypeUnitTest.assertEquals((int)96, (int)Type.BOOLEAN_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)96, (int)Type.BYTE_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)96, (int)Type.CHAR_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)96, (int)Type.SHORT_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)96, (int)Type.INT_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)98, (int)Type.FLOAT_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)97, (int)Type.LONG_TYPE.getOpcode(96));
        TypeUnitTest.assertEquals((int)99, (int)Type.DOUBLE_TYPE.getOpcode(96));
    }

    public void testHashcode() {
        Type.getType("Ljava/lang/Object;").hashCode();
    }

    public void testObjectType() throws Exception {
        Type t1 = Type.getObjectType("java/lang/Object");
        Type t2 = Type.getType("Ljava/lang/Object;");
        TypeUnitTest.assertEquals((int)t2.getSort(), (int)t1.getSort());
        TypeUnitTest.assertEquals((String)t2.getClassName(), (String)t1.getClassName());
        TypeUnitTest.assertEquals((String)t2.getDescriptor(), (String)t1.getDescriptor());
    }
}

