/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Edge;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassWriterComputeMaxsUnitTest
extends TestCase {
    private Field successors;
    private Field successor;
    private Field succ;
    private Field next;
    protected ClassWriter cw;
    protected MethodVisitor mv;
    private Label start;

    protected void setUp() throws Exception {
        Class<Label> lClass = Label.class;
        Class<Edge> eClass = Edge.class;
        try {
            this.successors = lClass.getDeclaredField("successors");
            this.successor = lClass.getDeclaredField("successor");
            this.succ = eClass.getDeclaredField("successor");
            this.next = eClass.getDeclaredField("next");
        }
        catch (RuntimeException exception) {
            String f = "src/org/objectweb/asm/optimizer/shrink.properties";
            Properties p = new Properties();
            FileInputStream is = new FileInputStream(f);
            try {
                p.load(is);
            }
            finally {
                is.close();
            }
            String l = String.valueOf(Type.getInternalName(lClass)) + ".";
            String e = String.valueOf(Type.getInternalName(eClass)) + ".";
            this.successors = lClass.getDeclaredField(p.getProperty(String.valueOf(l) + "successors"));
            this.successor = lClass.getDeclaredField(p.getProperty(String.valueOf(l) + "successor"));
            this.succ = eClass.getDeclaredField(p.getProperty(String.valueOf(e) + "successor"));
            this.next = eClass.getDeclaredField(p.getProperty(String.valueOf(e) + "next"));
        }
        this.cw = new ClassWriter(this.isComputeMaxs() ? 1 : 0);
        this.cw.visit(196653, 1, "C", null, "java/lang/Object", null);
        this.mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
        this.mv.visitCode();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        this.mv.visitInsn(177);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
        this.mv = this.cw.visitMethod(1, "m", "()V", null, null);
        this.mv.visitCode();
        this.start = new Label();
        this.LABEL(this.start);
    }

    protected boolean isComputeMaxs() {
        return true;
    }

    private void NOP() {
        this.mv.visitInsn(0);
    }

    private void PUSH() {
        this.mv.visitInsn(3);
    }

    private void ICONST_0() {
        this.mv.visitInsn(3);
    }

    private void ISTORE(int var) {
        this.mv.visitVarInsn(54, var);
    }

    private void ALOAD(int var) {
        this.mv.visitVarInsn(25, var);
    }

    private void ILOAD(int var) {
        this.mv.visitVarInsn(21, var);
    }

    private void ASTORE(int var) {
        this.mv.visitVarInsn(58, var);
    }

    private void RET(int var) {
        this.mv.visitVarInsn(169, var);
    }

    private void ATHROW() {
        this.mv.visitInsn(191);
    }

    private void ACONST_NULL() {
        this.mv.visitInsn(1);
    }

    private void RETURN() {
        this.mv.visitInsn(177);
    }

    private void LABEL(Label l) {
        this.mv.visitLabel(l);
    }

    private void IINC(int var, int amnt) {
        this.mv.visitIincInsn(var, amnt);
    }

    private void GOTO(Label l) {
        this.mv.visitJumpInsn(167, l);
    }

    private void JSR(Label l) {
        this.mv.visitJumpInsn(168, l);
    }

    private void IFNONNULL(Label l) {
        this.mv.visitJumpInsn(199, l);
    }

    private void IFNE(Label l) {
        this.mv.visitJumpInsn(154, l);
    }

    private void TRYCATCH(Label start, Label end, Label handler) {
        this.mv.visitTryCatchBlock(start, end, handler, null);
    }

    protected void assertMaxs(final int maxStack, final int maxLocals) {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
        this.cw.visitEnd();
        byte[] b = this.cw.toByteArray();
        ClassReader cr = new ClassReader(b);
        cr.accept(new ClassVisitor(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("m")) {
                    return new MethodVisitor(327680){

                        public void visitMaxs(int realMaxStack, int realMaxLocals) {
                            ClassWriterComputeMaxsUnitTest.assertEquals((String)"maxStack", (int)maxStack, (int)realMaxStack);
                            ClassWriterComputeMaxsUnitTest.assertEquals((String)"maxLocals", (int)maxLocals, (int)realMaxLocals);
                        }
                    };
                }
                return null;
            }
        }, 0);
        try {
            TestClassLoader loader = new TestClassLoader();
            Class<?> c = loader.defineClass("C", b);
            c.newInstance();
        }
        catch (Throwable t) {
            ClassWriterComputeMaxsUnitTest.fail((String)t.getMessage());
        }
    }

    protected void assertGraph(String graph) {
        HashMap expected = new HashMap();
        Properties p = new Properties();
        try {
            p.load(new ByteArrayInputStream(graph.getBytes()));
        }
        catch (Exception e) {
            ClassWriterComputeMaxsUnitTest.fail();
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            StringTokenizer st = new StringTokenizer(value, ",");
            HashSet<String> s = new HashSet<String>();
            while (st.hasMoreTokens()) {
                s.add(st.nextToken());
            }
            expected.put(key, s);
        }
        HashMap actual = new HashMap();
        try {
            Label l = this.start;
            while (l != null) {
                String key = "N" + l.getOffset();
                HashSet<String> value = new HashSet<String>();
                Edge e = (Edge)this.successors.get(l);
                while (e != null) {
                    value.add("N" + ((Label)this.succ.get(e)).getOffset());
                    e = (Edge)this.next.get(e);
                }
                actual.put(key, value);
                l = (Label)this.successor.get(l);
            }
        }
        catch (IllegalAccessException e) {
            ClassWriterComputeMaxsUnitTest.fail();
        }
        ClassWriterComputeMaxsUnitTest.assertEquals(expected, actual);
    }

    public void testBasic() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.JSR(L3);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L3);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.PUSH();
        this.PUSH();
        this.RET(2);
        this.LABEL(L1);
        this.JSR(L3);
        this.PUSH();
        this.PUSH();
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L4, L2);
        this.assertMaxs(4, 4);
        this.assertGraph("N0=N2\nN2=N22,N8\nN8=N14,N12\nN12=\nN14=N12,N25\nN22=N14,N25,N8\nN25=N27,N8\nN27=\n");
    }

    public void testIfElseInFinally() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        Label L5 = new Label();
        Label L6 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.JSR(L3);
        this.PUSH();
        this.PUSH();
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L3);
        this.ASTORE(2);
        this.PUSH();
        this.PUSH();
        this.ILOAD(1);
        this.IFNE(L4);
        this.IINC(1, 2);
        this.GOTO(L5);
        this.LABEL(L4);
        this.IINC(1, 3);
        this.LABEL(L5);
        this.RET(2);
        this.LABEL(L1);
        this.JSR(L3);
        this.LABEL(L6);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L6, L2);
        this.assertMaxs(5, 4);
        this.assertGraph("N0=N2\nN2=N34,N8\nN8=N16,N12\nN12=\nN16=N29,N32\nN29=N32\nN32=N37,N12\nN34=N16,N37,N8\nN37=\n");
    }

    public void testSimpleNestedFinally() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        Label L5 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.JSR(L3);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(4);
        this.JSR(L3);
        this.ALOAD(4);
        this.ATHROW();
        this.LABEL(L3);
        this.ASTORE(2);
        this.IINC(1, 2);
        this.JSR(L4);
        this.PUSH();
        this.PUSH();
        this.RET(2);
        this.LABEL(L5);
        this.ASTORE(5);
        this.JSR(L4);
        this.ALOAD(5);
        this.ATHROW();
        this.LABEL(L4);
        this.ASTORE(3);
        this.PUSH();
        this.PUSH();
        this.IINC(1, 3);
        this.RET(3);
        this.LABEL(L1);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L3, L5, L5);
        this.assertMaxs(5, 6);
        this.assertGraph("N0=N2\nN2=N11,N19,N8\nN8=N11,N46\nN11=N19,N16\nN16=\nN19=N26,N30,N38\nN26=N16,N30,N8\nN30=N38,N35\nN35=\nN38=N26,N35\nN46=\n");
    }

    public void testSubroutineWithNoRet() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.JSR(L1);
        this.GOTO(L2);
        this.LABEL(L3);
        this.ASTORE(2);
        this.JSR(L1);
        this.PUSH();
        this.PUSH();
        this.ALOAD(2);
        this.ATHROW();
        this.LABEL(L1);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L4);
        this.LABEL(L2);
        this.GOTO(L0);
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L3, L3);
        this.assertMaxs(1, 4);
        this.assertGraph("N0=N2\nN2=N11,N19,N8\nN8=N11,N26\nN11=N19,N15\nN15=\nN19=N29\nN26=N2\nN29=\n");
    }

    public void testSubroutineWithNoRet2() {
        Label L0 = new Label();
        Label L1 = new Label();
        this.ACONST_NULL();
        this.JSR(L0);
        this.NOP();
        this.LABEL(L0);
        this.ASTORE(0);
        this.ASTORE(0);
        this.RETURN();
        this.LABEL(L1);
        this.mv.visitLocalVariable("i", "I", null, L0, L1, 1);
        this.assertMaxs(2, 2);
        this.assertGraph("N0=N4,N5\nN4=N5\nN5=\nN8=\n");
    }

    public void testImplicitExit() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        Label L5 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L5);
        this.ACONST_NULL();
        this.IFNONNULL(L4);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.JSR(L1);
        this.GOTO(L2);
        this.LABEL(L3);
        this.ASTORE(2);
        this.JSR(L1);
        this.ALOAD(2);
        this.PUSH();
        this.PUSH();
        this.ATHROW();
        this.LABEL(L1);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L4);
        this.LABEL(L2);
        this.GOTO(L0);
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L3, L3);
        this.assertMaxs(1, 4);
        this.assertGraph("N0=N2\nN2=N6,N33\nN6=N23,N12,N15\nN12=N30,N15\nN15=N23,N19\nN19=\nN23=N33\nN30=N6\nN33=\n");
    }

    public void testImplicitExitToAnotherSubroutine() {
        Label T1 = new Label();
        Label C1 = new Label();
        Label S1 = new Label();
        Label L = new Label();
        Label C2 = new Label();
        Label S2 = new Label();
        Label W = new Label();
        Label X = new Label();
        int b = 1;
        int e1 = 2;
        int e2 = 3;
        int r1 = 4;
        int r2 = 5;
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(T1);
        this.JSR(S1);
        this.RETURN();
        this.LABEL(C1);
        this.ASTORE(e1);
        this.JSR(S1);
        this.PUSH();
        this.PUSH();
        this.ALOAD(e1);
        this.ATHROW();
        this.LABEL(S1);
        this.ASTORE(r1);
        this.PUSH();
        this.PUSH();
        this.GOTO(W);
        this.LABEL(L);
        this.JSR(S2);
        this.RETURN();
        this.LABEL(C2);
        this.ASTORE(e2);
        this.PUSH();
        this.PUSH();
        this.JSR(S2);
        this.ALOAD(e2);
        this.ATHROW();
        this.LABEL(S2);
        this.ASTORE(r2);
        this.ILOAD(b);
        this.IFNE(X);
        this.RET(r2);
        this.LABEL(W);
        this.ILOAD(b);
        this.IFNE(L);
        this.LABEL(X);
        this.RET(r1);
        this.TRYCATCH(T1, C1, C1);
        this.TRYCATCH(L, C2, C2);
        this.assertMaxs(5, 6);
        this.assertGraph("N0=N2\nN2=N6,N5,N14\nN5=N6\nN6=N14,N10\nN10=\nN14=N41\nN21=N24,N25,N33\nN24=N25\nN25=N31,N33\nN31=\nN33=N31,N45,N24\nN41=N45,N21\nN45=N5,N10\n");
    }

    public void testImplicitExitToAnotherSubroutine2() {
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.JSR(L1);
        this.RETURN();
        this.LABEL(L1);
        this.ASTORE(2);
        this.JSR(L2);
        this.GOTO(L3);
        this.LABEL(L2);
        this.ASTORE(3);
        this.ILOAD(1);
        this.IFNE(L3);
        this.RET(3);
        this.LABEL(L3);
        this.RET(2);
        this.assertMaxs(1, 4);
        this.assertGraph("N0=N6,N5\nN5=\nN6=N10,N13\nN10=N20\nN13=N20,N10\nN20=N5\n");
    }

    public void testInterleavedCode() {
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.ICONST_0();
        this.ISTORE(1);
        this.JSR(L1);
        this.GOTO(L2);
        this.LABEL(L1);
        this.ASTORE(2);
        this.IINC(1, 1);
        this.GOTO(L3);
        this.LABEL(L2);
        this.IINC(1, 2);
        this.GOTO(L4);
        this.LABEL(L3);
        this.IINC(1, 4);
        this.PUSH();
        this.PUSH();
        this.RET(2);
        this.LABEL(L4);
        this.PUSH();
        this.PUSH();
        this.RETURN();
        this.assertMaxs(4, 3);
        this.assertGraph("N0=N5,N8\nN5=N15\nN8=N21\nN15=N28\nN21=N5\nN28=\n");
    }

    public void testImplicitExitInTryCatch() {
        Label T1 = new Label();
        Label C1 = new Label();
        Label S1 = new Label();
        Label L = new Label();
        Label C2 = new Label();
        Label S2 = new Label();
        Label W = new Label();
        Label X = new Label();
        Label OC = new Label();
        int b = 1;
        int e1 = 2;
        int e2 = 3;
        int r1 = 4;
        int r2 = 5;
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(T1);
        this.JSR(S1);
        this.RETURN();
        this.LABEL(C1);
        this.ASTORE(e1);
        this.JSR(S1);
        this.ALOAD(e1);
        this.ATHROW();
        this.LABEL(S1);
        this.ASTORE(r1);
        this.GOTO(W);
        this.LABEL(L);
        this.JSR(S2);
        this.PUSH();
        this.PUSH();
        this.RETURN();
        this.LABEL(C2);
        this.ASTORE(e2);
        this.JSR(S2);
        this.ALOAD(e2);
        this.ATHROW();
        this.LABEL(S2);
        this.ASTORE(r2);
        this.ILOAD(b);
        this.IFNE(X);
        this.PUSH();
        this.PUSH();
        this.RET(r2);
        this.LABEL(W);
        this.ILOAD(b);
        this.IFNE(L);
        this.LABEL(X);
        this.RET(r1);
        this.LABEL(OC);
        this.IINC(b, 3);
        this.RETURN();
        this.TRYCATCH(T1, C1, C1);
        this.TRYCATCH(L, C2, C2);
        this.TRYCATCH(T1, OC, OC);
        this.assertMaxs(4, 6);
        this.assertGraph("N0=N2\nN2=N6,N45,N5,N12\nN5=N6,N45\nN6=N45,N12,N10\nN10=N45\nN12=N39,N45\nN17=N23,N45,N20,N29\nN20=N23,N45\nN23=N45,N27,N29\nN27=N45\nN29=N43,N45,N20,N27\nN39=N43,N45,N17\nN43=N45,N5,N10\nN45=\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TestClassLoader
    extends ClassLoader {
        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

