/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class PrintClass {
    static boolean code = false;
    static boolean constants = false;
    static boolean superClasses = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws IOException {
        int i;
        String[] file_name = new String[argv.length];
        int files = 0;
        String zip_file = null;
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].charAt(0) == '-') {
                if ("-constants".equals(argv[i])) {
                    constants = true;
                    continue;
                }
                if ("-code".equals(argv[i])) {
                    code = true;
                    continue;
                }
                if ("-super".equals(argv[i])) {
                    superClasses = true;
                    continue;
                }
                if (!"-zip".equals(argv[i])) continue;
                zip_file = argv[++i];
                continue;
            }
            if (argv[i].endsWith(".zip") || argv[i].endsWith(".jar")) {
                zip_file = argv[i];
                continue;
            }
            file_name[files++] = argv[i];
        }
        if (!constants) {
            code = true;
        }
        if (files == 0 && zip_file == null) {
            System.err.println("list: No input files specified");
            return;
        }
        if (zip_file != null) {
            for (i = 0; i < files; ++i) {
                file_name[i] = file_name[i].replace('.', '/');
            }
            try (ZipFile z = new ZipFile(zip_file);){
                TreeSet<ZipEntry> zipEntries = new TreeSet<ZipEntry>(new ZipEntryComparator());
                Enumeration<? extends ZipEntry> e = z.entries();
                while (e.hasMoreElements()) {
                    zipEntries.add(e.nextElement());
                }
                Iterator<ZipEntry> iterator = zipEntries.iterator();
                block12: while (iterator.hasNext()) {
                    ZipEntry ze = iterator.next();
                    String name = ze.getName();
                    if (!name.endsWith(".class")) continue;
                    if (files > 0) {
                        int i2 = 0;
                        while (true) {
                            if (i2 >= files) continue block12;
                            if (name.indexOf(file_name[i2]) >= 0) break;
                            ++i2;
                        }
                    }
                    PrintClass.printClass(new ClassParser(z.getInputStream(ze), name));
                }
                return;
            }
        }
        i = 0;
        while (i < files) {
            if (file_name[i].endsWith(".class")) {
                PrintClass.printClass(new ClassParser(file_name[i]));
            }
            ++i;
        }
    }

    private static void printClass(ClassParser parser) throws IOException {
        JavaClass java_class;
        if (superClasses) {
            try {
                for (java_class = parser.parse(); java_class != null; java_class = java_class.getSuperClass()) {
                    System.out.print(java_class.getClassName() + "  ");
                }
            }
            catch (ClassNotFoundException e) {
                System.out.println(e.getMessage());
            }
            System.out.println();
            return;
        }
        if (constants || code) {
            System.out.println(java_class);
        }
        if (constants) {
            System.out.println(java_class.getConstantPool());
        }
        if (code) {
            PrintClass.printCode(java_class.getMethods());
        }
    }

    public static void printCode(Method[] methods) {
        for (Method m : methods) {
            System.out.println(m);
            Code code = m.getCode();
            if (code == null) continue;
            System.out.println(code);
        }
    }

    static final class ZipEntryComparator
    implements Comparator<ZipEntry>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ZipEntryComparator() {
        }

        @Override
        public int compare(ZipEntry e1, ZipEntry e2) {
            int r;
            String s1 = e1.getName();
            int pos1 = s1.lastIndexOf(47);
            String p1 = "-";
            if (pos1 >= 0) {
                p1 = s1.substring(0, pos1);
            }
            String s2 = e2.getName();
            int pos2 = s2.lastIndexOf(47);
            String p2 = "-";
            if (pos2 >= 0) {
                p2 = s2.substring(0, pos2);
            }
            if ((r = p1.compareTo(p2)) != 0) {
                return r;
            }
            return s1.compareTo(s2);
        }
    }
}

