/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;

public class ReadReturnShouldBeChecked
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean sawRead = false;
    boolean sawSkip = false;
    boolean recentCallToAvailable = false;
    int sawAvailable = 0;
    boolean wasBufferedInputStream = false;
    BugAccumulator accumulator;
    private int locationOfCall;
    private String lastCallClass = null;
    private String lastCallMethod = null;
    private String lastCallSig = null;

    public ReadReturnShouldBeChecked(BugReporter bugReporter) {
        this.accumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        this.sawAvailable = 0;
        this.sawRead = false;
        this.sawSkip = false;
        super.visit(obj);
        this.accumulator.reportAccumulatedBugs();
    }

    private boolean isInputStream() {
        if (this.lastCallClass.startsWith("[")) {
            return false;
        }
        return (Subtypes2.instanceOf(this.lastCallClass, "java.io.InputStream") || Subtypes2.instanceOf(this.lastCallClass, "java.io.DataInput") || Subtypes2.instanceOf(this.lastCallClass, "java.io.Reader")) && !Subtypes2.instanceOf(this.lastCallClass, "java.io.ByteArrayInputStream");
    }

    private boolean isBufferedInputStream() {
        try {
            if (this.lastCallClass.startsWith("[")) {
                return false;
            }
            return Repository.instanceOf(this.lastCallClass, "java.io.BufferedInputStream");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isImageIOInputStream() {
        try {
            if (this.lastCallClass.startsWith("[")) {
                return false;
            }
            return Repository.instanceOf(this.lastCallClass, "javax.imageio.stream.ImageInputStream");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 || seen == 185) {
            this.lastCallClass = this.getDottedClassConstantOperand();
            this.lastCallMethod = this.getNameConstantOperand();
            this.lastCallSig = this.getSigConstantOperand();
        }
        if ((seen == 182 || seen == 185) && ("available".equals(this.getNameConstantOperand()) && "()I".equals(this.getSigConstantOperand()) || this.getNameConstantOperand().startsWith("get") && this.getNameConstantOperand().endsWith("Length") && "()I".equals(this.getSigConstantOperand()) || "java/io/File".equals(this.getClassConstantOperand()) && "length".equals(this.getNameConstantOperand()) && "()J".equals(this.getSigConstantOperand()))) {
            this.sawAvailable = 70;
            return;
        }
        --this.sawAvailable;
        if ((seen == 182 || seen == 185) && "read".equals(this.getNameConstantOperand()) && ("([B)I".equals(this.getSigConstantOperand()) || "([BII)I".equals(this.getSigConstantOperand()) || "([C)I".equals(this.getSigConstantOperand()) || "([CII)I".equals(this.getSigConstantOperand())) && this.isInputStream()) {
            this.sawRead = true;
            this.recentCallToAvailable = this.sawAvailable > 0;
            this.locationOfCall = this.getPC();
            return;
        }
        if ((seen == 182 || seen == 185) && ("skip".equals(this.getNameConstantOperand()) && "(J)J".equals(this.getSigConstantOperand()) || "skipBytes".equals(this.getNameConstantOperand()) && "(I)I".equals(this.getSigConstantOperand())) && this.isInputStream() && !this.isImageIOInputStream()) {
            this.wasBufferedInputStream = this.isBufferedInputStream();
            this.sawSkip = true;
            this.locationOfCall = this.getPC();
            this.recentCallToAvailable = this.sawAvailable > 0 && !this.wasBufferedInputStream;
            return;
        }
        if (seen == 87 || seen == 88) {
            if (this.sawRead) {
                this.accumulator.accumulateBug(new BugInstance(this, "RR_NOT_CHECKED", this.recentCallToAvailable ? 3 : 2).addClassAndMethod(this).addCalledMethod(this.lastCallClass, this.lastCallMethod, this.lastCallSig, false), SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, this.locationOfCall));
            } else if (this.sawSkip) {
                this.accumulator.accumulateBug(new BugInstance(this, "SR_NOT_CHECKED", this.wasBufferedInputStream ? 1 : (this.recentCallToAvailable ? 3 : 2)).addClassAndMethod(this).addCalledMethod(this.lastCallClass, this.lastCallMethod, this.lastCallSig, false), SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, this.locationOfCall));
            }
        }
        this.sawRead = false;
        this.sawSkip = false;
    }
}

