/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;

public class DontCatchIllegalMonitorStateException
extends PreorderVisitor
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean("dcimse.debug");
    BugReporter bugReporter;
    Set<String> msgs = null;
    ClassContext classContext;

    public DontCatchIllegalMonitorStateException(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            this.msgs = new HashSet<String>();
        }
    }

    @Override
    public void visit(ExceptionTable obj) {
        if (DEBUG) {
            String[] names;
            for (String name : names = obj.getExceptionNames()) {
                if (!"java.lang.Exception".equals(name) && !"java.lang.Throwable".equals(name)) continue;
                System.out.println(name + " thrown by " + this.getFullyQualifiedMethodName());
            }
        }
    }

    @Override
    public void visit(CodeException obj) {
        String msg;
        int type = obj.getCatchType();
        if (type == 0) {
            return;
        }
        String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
        if (DEBUG && this.msgs.add(msg = "Catching " + name + " in " + this.getFullyQualifiedMethodName())) {
            System.out.println(msg);
        }
        if ("java.lang.IllegalMonitorStateException".equals(name)) {
            this.bugReporter.reportBug(new BugInstance(this, "IMSE_DONT_CATCH_IMSE", 1).addClassAndMethod(this).addSourceLine(this.classContext, this, obj.getHandlerPC()));
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        classContext.getJavaClass().accept(this);
    }

    @Override
    public void report() {
    }
}

