/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.StoreInstruction;

public class FinallyDuplicatesInfoFactory
implements IMethodAnalysisEngine<FinallyDuplicatesInfo> {
    private static final FinallyDuplicatesInfo NONE_FINALLY_INFO = new FinallyDuplicatesInfo();

    private static int getInstructionNumber(int[] positions, int position) {
        return Math.abs(Arrays.binarySearch(positions, position));
    }

    @Override
    public FinallyDuplicatesInfo analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
        if (method == null) {
            return NONE_FINALLY_INFO;
        }
        BitSet exceptionTargets = new BitSet();
        LinkedHashMap<Integer, TryBlock> finallyTargets = new LinkedHashMap<Integer, TryBlock>();
        for (CodeException codeException : method.getCode().getExceptionTable()) {
            if (codeException.getCatchType() == 0) {
                TryBlock block = (TryBlock)finallyTargets.get(codeException.getHandlerPC());
                if (block == null) {
                    block = new TryBlock(codeException.getHandlerPC());
                    finallyTargets.put(codeException.getHandlerPC(), block);
                }
                if (codeException.getStartPC() != codeException.getHandlerPC()) {
                    block.normalBlocks.put(codeException.getStartPC(), codeException.getEndPC());
                }
            }
            exceptionTargets.set(codeException.getHandlerPC());
        }
        if (finallyTargets.isEmpty()) {
            return NONE_FINALLY_INFO;
        }
        MethodGen methodGen = analysisCache.getMethodAnalysis(MethodGen.class, descriptor);
        if (methodGen == null) {
            return NONE_FINALLY_INFO;
        }
        InstructionList il = methodGen.getInstructionList();
        BitSet branchTargets = new BitSet();
        for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
            Instruction inst = ih.getInstruction();
            if (!(inst instanceof BranchInstruction)) continue;
            branchTargets.set(((BranchInstruction)inst).getTarget().getPosition());
        }
        BitSet usedTargets = new BitSet();
        ArrayList<SortedMap<Integer, Integer>> duplicates = new ArrayList<SortedMap<Integer, Integer>>();
        for (TryBlock block : finallyTargets.values()) {
            if (usedTargets.get(block.catchAnyAddress)) continue;
            block.update(exceptionTargets, branchTargets, il, finallyTargets.keySet(), usedTargets);
            if (block.incorrect || block.duplicates.size() <= 1) continue;
            duplicates.add(block.duplicates);
        }
        if (duplicates.isEmpty()) {
            return NONE_FINALLY_INFO;
        }
        return new FinallyDuplicatesInfo(il.getInstructionPositions(), duplicates);
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerMethodAnalysisEngine(FinallyDuplicatesInfo.class, this);
    }

    private static class TryBlock {
        boolean incorrect = false;
        final int catchAnyAddress;
        InstructionHandle firstInstruction;
        SortedMap<Integer, Integer> normalBlocks = new TreeMap<Integer, Integer>();
        SortedMap<Integer, Integer> duplicates = new TreeMap<Integer, Integer>();

        public TryBlock(int catchAnyAddress) {
            this.catchAnyAddress = catchAnyAddress;
        }

        public void update(BitSet exceptionTargets, BitSet branchTargets, InstructionList il, Set<Integer> finallyTargets, BitSet usedTargets) {
            int end;
            int start;
            InstructionHandle ih;
            int lastEnd;
            block11: {
                Instruction inst;
                lastEnd = -1;
                ih = il.findHandle(this.catchAnyAddress);
                if (ih == null || !(ih.getInstruction() instanceof ASTORE)) {
                    this.incorrect = true;
                    return;
                }
                int varIndex = ((ASTORE)ih.getInstruction()).getIndex();
                this.firstInstruction = ih.getNext();
                if (this.firstInstruction == null) {
                    this.incorrect = true;
                    return;
                }
                end = start = this.firstInstruction.getPosition();
                do {
                    if ((ih = ih.getNext()) == null) {
                        this.incorrect = true;
                        return;
                    }
                    end = ih.getPosition();
                    inst = ih.getInstruction();
                    if (!(inst instanceof ALOAD) || ((ALOAD)inst).getIndex() != varIndex) continue;
                    if ((ih = ih.getNext()) == null || !(ih.getInstruction() instanceof ATHROW)) {
                        this.incorrect = true;
                        return;
                    }
                    break block11;
                } while (!(inst instanceof JSR));
                this.incorrect = true;
                return;
            }
            this.duplicates.put(start, end);
            this.normalBlocks.put(this.catchAnyAddress, this.catchAnyAddress);
            for (Map.Entry entry : this.normalBlocks.entrySet()) {
                int candidateStart;
                int block2end;
                if (lastEnd > -1 && (Integer)entry.getKey() > lastEnd && (block2end = this.equalBlocks(this.firstInstruction, il.findHandle(candidateStart = lastEnd), end - start, il.getInstructionPositions())) > 0 && block2end <= (Integer)entry.getKey()) {
                    int newKey;
                    this.duplicates.put(candidateStart, block2end);
                    while ((newKey = Math.min(exceptionTargets.nextSetBit(block2end + 1), branchTargets.nextSetBit(block2end + 1))) >= 0 && newKey <= (Integer)entry.getKey()) {
                        InstructionHandle ih2 = il.findHandle(newKey);
                        if (exceptionTargets.get(newKey)) {
                            ih2 = ih2.getNext();
                        }
                        candidateStart = ih2.getPosition();
                        block2end = this.equalBlocks(this.firstInstruction, ih2, end - start, il.getInstructionPositions());
                        if (block2end > 0 && block2end <= (Integer)entry.getKey()) {
                            this.duplicates.put(candidateStart, block2end);
                            continue;
                        }
                        block2end = newKey;
                    }
                }
                lastEnd = (Integer)entry.getValue();
            }
            int block2end = this.equalBlocks(this.firstInstruction, ih = ih.getNext(), end - start, il.getInstructionPositions());
            if (block2end > 0) {
                this.duplicates.put(ih.getPosition(), block2end);
            }
        }

        private int equalBlocks(InstructionHandle ih1, InstructionHandle ih2, int length, int[] positions) {
            if (length == 0) {
                return -1;
            }
            if (ih1 == null || ih2 == null) {
                return -1;
            }
            int start1 = ih1.getPosition();
            int start2 = ih2.getPosition();
            int startNum1 = FinallyDuplicatesInfoFactory.getInstructionNumber(positions, start1);
            int startNum2 = FinallyDuplicatesInfoFactory.getInstructionNumber(positions, start2);
            HashMap<Integer, Integer> lvMap = new HashMap<Integer, Integer>();
            while (ih1 != null && ih2 != null) {
                Instruction inst2;
                Instruction inst1 = ih1.getInstruction();
                if (!inst1.equals(inst2 = ih2.getInstruction())) {
                    if (inst1 instanceof LocalVariableInstruction && inst2 instanceof LocalVariableInstruction) {
                        if (inst1.getClass() != inst2.getClass()) {
                            return -1;
                        }
                        LocalVariableInstruction lvi1 = (LocalVariableInstruction)inst1;
                        LocalVariableInstruction lvi2 = (LocalVariableInstruction)inst2;
                        int lv1 = lvi1.getIndex();
                        int lv2 = lvi2.getIndex();
                        Integer targetLV = (Integer)lvMap.get(lv1);
                        if (targetLV == null) {
                            if (!(lvi1 instanceof StoreInstruction)) {
                                return -1;
                            }
                            lvMap.put(lv1, lv2);
                        } else if (targetLV != lv2) {
                            return -1;
                        }
                    } else {
                        if (inst1.getOpcode() != inst2.getOpcode()) {
                            return -1;
                        }
                        if (!(inst1 instanceof BranchInstruction)) {
                            return -1;
                        }
                        int target1 = ((BranchInstruction)inst1).getTarget().getPosition();
                        int target2 = ((BranchInstruction)inst2).getTarget().getPosition();
                        if (FinallyDuplicatesInfoFactory.getInstructionNumber(positions, target1) - startNum1 != FinallyDuplicatesInfoFactory.getInstructionNumber(positions, target2) - startNum2 && target1 != start1 + length) {
                            return -1;
                        }
                    }
                }
                if (ih1.getPosition() - start1 + inst1.getLength() >= length) {
                    return ih2.getPosition() + inst2.getLength();
                }
                ih1 = ih1.getNext();
                ih2 = ih2.getNext();
            }
            return -1;
        }

        public String toString() {
            if (this.incorrect) {
                return "INCORRECT";
            }
            return this.duplicates.toString();
        }
    }

    public static class FinallyDuplicatesInfo {
        private final List<SortedMap<Integer, Integer>> duplicateBlocks;
        private final int[] positions;

        public FinallyDuplicatesInfo(int[] positions, List<SortedMap<Integer, Integer>> duplicateBlocks) {
            this.positions = positions;
            this.duplicateBlocks = duplicateBlocks;
        }

        public FinallyDuplicatesInfo() {
            this.duplicateBlocks = null;
            this.positions = null;
        }

        public BitSet getDuplicates(int pos) {
            boolean changed;
            if (this.duplicateBlocks == null) {
                return new BitSet();
            }
            BitSet current = new BitSet();
            current.set(pos);
            do {
                changed = false;
                for (SortedMap<Integer, Integer> duplicates : this.duplicateBlocks) {
                    int i = current.nextSetBit(0);
                    while (i >= 0) {
                        int offset = this.getOffset(duplicates, i);
                        if (offset >= 0) {
                            for (Integer key : duplicates.keySet()) {
                                int dupPosition = this.positions[FinallyDuplicatesInfoFactory.getInstructionNumber(this.positions, key) + offset];
                                if (current.get(dupPosition)) continue;
                                changed = true;
                                current.set(dupPosition);
                            }
                        }
                        i = current.nextSetBit(i + 1);
                    }
                }
            } while (changed && this.duplicateBlocks.size() > 1);
            current.clear(pos);
            return current;
        }

        public List<Edge> getDuplicates(CFG cfg, Edge edge) {
            InstructionHandle ih = ((BasicBlock)edge.getSource()).getLastInstruction();
            if (ih == null) {
                return Collections.emptyList();
            }
            BitSet duplicates = this.getDuplicates(ih.getPosition());
            if (duplicates.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Edge> result = new ArrayList<Edge>();
            Iterator edgeIterator = cfg.edgeIterator();
            while (edgeIterator.hasNext()) {
                InstructionHandle lastInst;
                Edge next = (Edge)edgeIterator.next();
                if (next.getType() != edge.getType() || (lastInst = ((BasicBlock)next.getSource()).getLastInstruction()) == null || lastInst.getPosition() < 0 || !duplicates.get(lastInst.getPosition())) continue;
                result.add(next);
            }
            return result;
        }

        private int getOffset(SortedMap<Integer, Integer> duplicates, int i) {
            SortedMap<Integer, Integer> headMap = duplicates.headMap(i + 1);
            if (headMap.isEmpty()) {
                return -1;
            }
            int end = (Integer)headMap.get(headMap.lastKey());
            if (end <= i) {
                return -1;
            }
            return FinallyDuplicatesInfoFactory.getInstructionNumber(this.positions, i) - FinallyDuplicatesInfoFactory.getInstructionNumber(this.positions, headMap.lastKey());
        }

        public String toString() {
            return String.valueOf(this.duplicateBlocks);
        }
    }
}

